/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class FastlaneTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties MODULE_KEY = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.xcode.bamboo-xcode-plugin:fastlaneTaskType");
    @NotNull
    private String lane;
    @Nullable
    private String environmentVariables;
    @Nullable
    private String executableLabel;
    @Nullable
    private String workingSubdirectory;

    protected FastlaneTaskProperties() {
    }

    public FastlaneTaskProperties(@Nullable String description, boolean enabled, @NotNull String lane, @Nullable String environmentVariables, @NotNull String executableLabel, @Nullable String workingSubdirectory, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions) throws PropertiesValidationException {
        super(description, enabled, requirements, conditions);
        this.lane = lane;
        this.environmentVariables = environmentVariables;
        this.executableLabel = executableLabel;
        this.workingSubdirectory = workingSubdirectory;
        this.validate();
    }

    @NotNull
    public String getLane() {
        return this.lane;
    }

    @Nullable
    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Nullable
    public String getExecutableLabel() {
        return this.executableLabel;
    }

    @Nullable
    public String getWorkingSubdirectory() {
        return this.workingSubdirectory;
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return MODULE_KEY;
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"Fastlane task");
        ImporterUtils.checkThat((ValidationContext)context, (boolean)StringUtils.isNotBlank((CharSequence)this.lane), (String)"Lane is not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)context, (boolean)StringUtils.isNotBlank((CharSequence)this.executableLabel), (String)"Executable label is not defined", (Object[])new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FastlaneTaskProperties that = (FastlaneTaskProperties)((Object)o);
        return Objects.equals(this.lane, that.lane) && Objects.equals(this.environmentVariables, that.environmentVariables) && Objects.equals(this.executableLabel, that.executableLabel) && Objects.equals(this.workingSubdirectory, that.workingSubdirectory);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lane, this.environmentVariables, this.executableLabel, this.workingSubdirectory);
    }
}

