/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.condition.ConditionProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.GulpTask;
import com.atlassian.bamboo.specs.model.task.BaseNodeTaskProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class GulpTaskProperties
extends BaseNodeTaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-nodejs-plugin:task.builder.gulp");
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Gulp task");
    @NotNull
    private String gulpExecutable = GulpTask.DEFAULT_GULP_EXECUTABLE;
    @Nullable
    private String task;
    @Nullable
    private String gulpfile;

    protected GulpTaskProperties() {
    }

    public GulpTaskProperties(@Nullable String description, boolean enabled, @NotNull String nodeExecutable, @Nullable String environmentVariables, @Nullable String workingSubdirectory, @NotNull String gulpExecutable, @Nullable String task, @Nullable String gulpfile, @NotNull List<RequirementProperties> requirements, @NotNull List<? extends ConditionProperties> conditions) throws PropertiesValidationException {
        super(description, enabled, nodeExecutable, environmentVariables, workingSubdirectory, requirements, conditions);
        this.gulpExecutable = gulpExecutable;
        this.task = task;
        this.gulpfile = gulpfile;
        this.validate();
    }

    @Override
    public void validate() {
        super.validate();
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.gulpExecutable), (String)"Gulp executable is not defined", (Object[])new Object[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GulpTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GulpTaskProperties that = (GulpTaskProperties)((Object)o);
        return Objects.equals(this.gulpExecutable, that.gulpExecutable) && Objects.equals(this.task, that.task) && Objects.equals(this.gulpfile, that.gulpfile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.gulpExecutable, this.task, this.gulpfile);
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @Override
    protected ValidationContext getValidationContext() {
        return VALIDATION_CONTEXT;
    }

    @NotNull
    public String getGulpExecutable() {
        return this.gulpExecutable;
    }

    @Nullable
    public String getTask() {
        return this.task;
    }

    @Nullable
    public String getGulpfile() {
        return this.gulpfile;
    }
}

