/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.autolink.internal;

import java.util.EnumSet;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.node.Visitor;
import org.commonmark.parser.PostProcessor;
import org.nibor.autolink.LinkExtractor;
import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.Span;

public class AutolinkPostProcessor
implements PostProcessor {
    private LinkExtractor linkExtractor = LinkExtractor.builder().linkTypes(EnumSet.of(LinkType.URL, LinkType.EMAIL)).build();

    public Node process(Node node) {
        AutolinkVisitor autolinkVisitor = new AutolinkVisitor();
        node.accept((Visitor)autolinkVisitor);
        return node;
    }

    private void linkify(Text textNode) {
        String literal = textNode.getLiteral();
        Text lastNode = textNode;
        for (Span span : this.linkExtractor.extractSpans((CharSequence)literal)) {
            String text = literal.substring(span.getBeginIndex(), span.getEndIndex());
            if (span instanceof LinkSpan) {
                String destination = AutolinkPostProcessor.getDestination((LinkSpan)span, text);
                Text contentNode = new Text(text);
                Link linkNode = new Link(destination, null);
                linkNode.appendChild((Node)contentNode);
                lastNode = AutolinkPostProcessor.insertNode((Node)linkNode, (Node)lastNode);
                continue;
            }
            lastNode = AutolinkPostProcessor.insertNode((Node)new Text(text), (Node)lastNode);
        }
        textNode.unlink();
    }

    private static String getDestination(LinkSpan linkSpan, String linkText) {
        if (linkSpan.getType() == LinkType.EMAIL) {
            return "mailto:" + linkText;
        }
        return linkText;
    }

    private static Node insertNode(Node node, Node insertAfterNode) {
        insertAfterNode.insertAfter(node);
        return node;
    }

    private class AutolinkVisitor
    extends AbstractVisitor {
        int inLink = 0;

        private AutolinkVisitor() {
        }

        public void visit(Link link) {
            ++this.inLink;
            super.visit(link);
            --this.inLink;
        }

        public void visit(Text text) {
            if (this.inLink == 0) {
                AutolinkPostProcessor.this.linkify(text);
            }
        }
    }
}

