/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring;

import com.atlassian.connect.spring.AtlassianHost;
import java.util.Objects;
import java.util.Optional;

public final class AtlassianHostUser {
    private AtlassianHost host;
    @Deprecated
    private Optional<String> userKey;
    private Optional<String> userAccountId;

    protected AtlassianHostUser() {
    }

    @Deprecated
    public AtlassianHostUser(AtlassianHost host, Optional<String> optionalUserKey) {
        this.host = host;
        this.userKey = optionalUserKey;
        this.userAccountId = Optional.empty();
    }

    public AtlassianHost getHost() {
        return this.host;
    }

    @Deprecated
    public Optional<String> getUserKey() {
        return this.userKey;
    }

    public Optional<String> getUserAccountId() {
        return this.userAccountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlassianHostUser that = (AtlassianHostUser)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.userKey, that.userKey) && Objects.equals(this.userAccountId, that.userAccountId);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.userKey, this.userAccountId);
    }

    public String toString() {
        return String.format("AtlassianHostUser{host=%s, userKey='%s', userAccountId='%s'}", this.host, this.userKey.orElse("null"), this.userAccountId.orElse("null"));
    }

    public static AtlassianHostUserBuilder builder(AtlassianHost host) {
        return new AtlassianHostUserBuilder(host);
    }

    public static class AtlassianHostUserBuilder {
        private AtlassianHostUser hostUser = new AtlassianHostUser();

        private AtlassianHostUserBuilder(AtlassianHost host) {
            if (host == null) {
                throw new IllegalArgumentException("Host must be set for user");
            }
            this.hostUser.host = host;
            this.hostUser.userKey = Optional.empty();
            this.hostUser.userAccountId = Optional.empty();
        }

        @Deprecated
        public AtlassianHostUserBuilder withUserKey(String userKey) {
            if (userKey == null) {
                throw new IllegalArgumentException("The userKey can not be null.");
            }
            this.hostUser.userKey = Optional.of(userKey);
            return this;
        }

        public AtlassianHostUserBuilder withUserAccountId(String userAccountId) {
            if (userAccountId == null) {
                throw new IllegalArgumentException("The userAccountId can not be null.");
            }
            this.hostUser.userAccountId = Optional.of(userAccountId);
            return this;
        }

        public AtlassianHostUser build() {
            return this.hostUser;
        }
    }
}

