/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.jwt;

import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

public class CanonicalRequestUtil {
    public static String getRelativePath(String requestPath, String contextPath) {
        String contextPathToRemove = null == contextPath || "/".equals(contextPath) ? "" : contextPath;
        return Optional.ofNullable(requestPath).filter(s -> !StringUtils.isEmpty((Object)s)).map(s -> s.startsWith(contextPathToRemove) ? s.substring(contextPathToRemove.length()) : s).map(s -> StringUtils.trimTrailingCharacter((String)s, (char)'/')).orElse("/");
    }

    public static String toVerboseString(CanonicalHttpRequest request) {
        return new ToStringCreator((Object)request).append("method", (Object)request.getMethod()).append("relativePath", (Object)request.getRelativePath()).append("parameterMap", (Object)CanonicalRequestUtil.mapToString(request.getParameterMap())).toString();
    }

    private static String mapToString(Map<String, String[]> parameterMap) {
        StringBuilder sb = new StringBuilder().append('[');
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            sb.append(entry.getKey()).append(" -> ");
            String[] value = entry.getValue();
            if (value != null) {
                sb.append("(");
                CanonicalRequestUtil.appendTo(sb, Arrays.asList(value), ",");
                sb.append(")");
            }
            sb.append(',');
        }
        return sb.append(']').toString();
    }

    private static StringBuilder appendTo(StringBuilder appendable, Iterable<?> parts, CharSequence separator) {
        Iterator<?> iterator = parts.iterator();
        if (iterator.hasNext()) {
            appendable.append(CanonicalRequestUtil.toString(iterator.next()));
            while (iterator.hasNext()) {
                appendable.append(separator);
                appendable.append(CanonicalRequestUtil.toString(iterator.next()));
            }
        }
        return appendable;
    }

    private static CharSequence toString(Object part) {
        return part instanceof CharSequence ? (CharSequence)part : part.toString();
    }
}

