/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.jwt;

import com.atlassian.connect.spring.internal.jwt.JwtParseException;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Map;

public class JwtParser {
    public JWTClaimsSet parse(String jwt) throws JwtParseException {
        JWSObject jwsObject = this.parseJWSObject(jwt);
        try {
            return JWTClaimsSet.parse((Map)jwsObject.getPayload().toJSONObject());
        }
        catch (ParseException e) {
            throw new JwtParseException(e);
        }
    }

    private JWSObject parseJWSObject(String jwt) throws JwtParseException {
        JWSObject jwsObject;
        try {
            jwsObject = JWSObject.parse((String)jwt);
        }
        catch (ParseException e) {
            throw new JwtParseException(e);
        }
        return jwsObject;
    }
}

