/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.jwt;

import com.atlassian.connect.spring.internal.jwt.JwtSigningException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;

public class JwtWriter {
    private final JWSAlgorithm algorithm;
    private final JWSSigner signer;
    private static final String JWT = "JWT";

    public JwtWriter(JWSAlgorithm algorithm, JWSSigner signer) {
        this.algorithm = algorithm;
        this.signer = signer;
    }

    public String jsonToJwt(String json) throws JwtSigningException {
        return this.generateJwsObject(json).serialize();
    }

    JWSObject generateJwsObject(String payload) {
        JWSHeader header = new JWSHeader.Builder(this.algorithm).type(new JOSEObjectType(JWT)).build();
        JWSObject jwsObject = new JWSObject(header, new Payload(payload));
        try {
            jwsObject.sign(this.signer);
        }
        catch (JOSEException e) {
            throw new JwtSigningException((Exception)((Object)e));
        }
        return jwsObject;
    }
}

