/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.scanner;

import com.atlassian.maven.plugin.clover.internal.CompilerConfiguration;
import com.atlassian.maven.plugin.clover.internal.scanner.CloverSourceScanner;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.FileSelector;

public abstract class AbstractCloverSourceScanner
implements CloverSourceScanner {
    private final CompilerConfiguration configuration;
    private final File targetDir;

    public AbstractCloverSourceScanner(CompilerConfiguration configuration, String outputSourceDirectory) {
        this.configuration = configuration;
        this.targetDir = new File(outputSourceDirectory);
    }

    protected CompilerConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map getSourceFilesToInstrument() {
        return this.computeIncludedFiles(this.getScanner());
    }

    public Map getExcludedFiles() {
        return this.computeExcludedFiles(this.getScanner());
    }

    protected abstract List getSourceRoots();

    protected abstract String getSourceDirectory();

    private DirectoryScanner getScanner() {
        Set includes = this.getConfiguration().getIncludes();
        Set excludes = this.getConfiguration().getExcludes();
        this.configuration.getLog().debug((CharSequence)("excludes patterns = " + excludes));
        this.configuration.getLog().debug((CharSequence)("includes patterns = " + includes));
        DirectoryScanner dirScan = new DirectoryScanner();
        dirScan.addExcludes(excludes.toArray(new String[excludes.size()]));
        dirScan.setIncludes(includes.toArray(new String[includes.size()]));
        dirScan.addDefaultExcludes();
        DependSelector selector = new DependSelector();
        selector.setTargetdir(this.targetDir);
        dirScan.setSelectors(new FileSelector[]{selector});
        return dirScan;
    }

    private Map computeExcludedFiles(final DirectoryScanner scanner) {
        final HashMap files = new HashMap();
        this.visitSourceRoots(new SourceRootVisitor(){

            public void visitDir(File dir) {
                scanner.setBasedir(dir);
                String[] configuredIncludes = AbstractCloverSourceScanner.this.getConfiguration().getIncludes().toArray(new String[0]);
                String[] includes = AbstractCloverSourceScanner.this.concatArrays(configuredIncludes, DirectoryScanner.getDefaultExcludes());
                scanner.setIncludes(includes);
                scanner.scan();
                String[] sourcesToAdd = AbstractCloverSourceScanner.this.concatArrays(scanner.getExcludedFiles(), scanner.getNotIncludedFiles());
                AbstractCloverSourceScanner.this.configuration.getLog().debug((CharSequence)("excluding files from instrumentation = " + Arrays.asList(sourcesToAdd)));
                if (sourcesToAdd.length > 0) {
                    files.put(dir.getPath(), sourcesToAdd);
                }
            }
        });
        return files;
    }

    private Map computeIncludedFiles(final DirectoryScanner scanner) {
        final HashMap files = new HashMap();
        this.visitSourceRoots(new SourceRootVisitor(){

            public void visitDir(File dir) {
                scanner.setBasedir(dir);
                scanner.scan();
                String[] sourcesToAdd = scanner.getIncludedFiles();
                AbstractCloverSourceScanner.this.configuration.getLog().debug((CharSequence)("including files for instrumentation = " + Arrays.asList(sourcesToAdd)));
                if (sourcesToAdd.length > 0) {
                    files.put(dir.getAbsolutePath(), sourcesToAdd);
                }
            }
        });
        return files;
    }

    private String[] concatArrays(String[] a1, String[] a2) {
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    private List getResolvedSourceRoots() {
        return this.getConfiguration().includesAllSourceRoots() ? this.getSourceRoots() : Collections.singletonList(this.getSourceDirectory());
    }

    private void visitSourceRoots(SourceRootVisitor visitor) {
        Iterator sourceRoots = this.getResolvedSourceRoots().iterator();
        while (sourceRoots.hasNext()) {
            File sourceRoot = new File((String)sourceRoots.next());
            if (!sourceRoot.exists()) continue;
            visitor.visitDir(sourceRoot);
        }
    }

    static interface SourceRootVisitor {
        public void visitDir(File var1);
    }
}

