/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow;

import com.atlassian.maven.plugins.jgitflow.AbstractJGitFlowMojo;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="release-finish", aggregator=true)
public class ReleaseFinishMojo
extends AbstractJGitFlowMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules = false;
    @Parameter(defaultValue="false", property="allowSnapshots")
    private boolean allowSnapshots = false;
    @Parameter(property="developmentVersion")
    private String developmentVersion;
    @Parameter(defaultValue="false", property="pushReleases")
    private boolean pushReleases = false;
    @Parameter(defaultValue="false", property="noDeploy")
    private boolean noDeploy = false;
    @Parameter(defaultValue="false", property="keepBranch")
    private boolean keepBranch = false;
    @Parameter(defaultValue="false", property="squash")
    private boolean squash = false;
    @Parameter(defaultValue="false", property="noTag")
    private boolean noTag = false;
    @Parameter(defaultValue="false", property="noReleaseBuild")
    private boolean noReleaseBuild = false;
    @Parameter(defaultValue="false", property="noReleaseMerge")
    private boolean noReleaseMerge = false;
    @Parameter(defaultValue="true", property="useReleaseProfile")
    private boolean useReleaseProfile = true;
    @Parameter(defaultValue="false", property="pullMaster")
    private boolean pullMaster = false;
    @Parameter(defaultValue="false", property="pullDevelop")
    private boolean pullDevelop = false;
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies = true;
    @Parameter(property="tagMessage")
    private String tagMessage;
    @Parameter(property="releaseBranchVersionSuffix", defaultValue="")
    private String releaseBranchVersionSuffix;
    @Component(hint="release")
    FlowReleaseManager releaseManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setInteractive(this.getSettings().isInteractiveMode()).setAutoVersionSubmodules(this.autoVersionSubmodules).setDefaultDevelopmentVersion(this.developmentVersion).setReleaseBranchVersionSuffix(this.releaseBranchVersionSuffix).setPushReleases(this.pushReleases).setKeepBranch(this.keepBranch).setSquash(this.squash).setNoTag(this.noTag).setNoBuild(this.noReleaseBuild).setNoDeploy(this.noDeploy).setUseReleaseProfile(this.useReleaseProfile).setTagMessage(this.tagMessage).setUpdateDependencies(this.updateDependencies).setAllowSnapshots(this.allowSnapshots).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setNoReleaseMerge(this.noReleaseMerge).setAllowRemote(this.isRemoteAllowed()).setDefaultOriginUrl(this.defaultOriginUrl).setScmCommentPrefix(this.scmCommentPrefix).setPullMaster(this.pullMaster).setPullDevelop(this.pullDevelop).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.finish(ctx, this.getReactorProjects(), this.session);
        }
        catch (JGitFlowReleaseException e) {
            throw new MojoExecutionException("Error finishing release: " + e.getMessage(), (Exception)e);
        }
    }
}

