/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.helper;

import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.maven.plugins.jgitflow.PrettyPrompter;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.helper.ProjectHelper;
import com.atlassian.maven.plugins.jgitflow.util.ConsoleCredentialsProvider;
import com.atlassian.maven.plugins.jgitflow.util.SshCredentialsProvider;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.apache.maven.shared.release.version.HotfixVersionInfo;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;

public class DefaultProjectHelper
extends AbstractLogEnabled
implements ProjectHelper {
    private static final String ls = System.getProperty("line.separator");
    private static String OS = System.getProperty("os.name").toLowerCase();
    private static boolean isWindows = OS.indexOf("win") >= 0;
    private static boolean isCygwin = isWindows && !Strings.isNullOrEmpty((String)System.getenv("TERM"));
    private PrettyPrompter prompter;
    private ArtifactFactory artifactFactory;
    private final Map<String, Map<String, String>> originalVersions = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> releaseVersions = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> developmentVersions = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> hotfixVersions = new HashMap<String, Map<String, String>>();

    @Override
    public void fixCygwinIfNeeded(JGitFlow flow) throws JGitFlowReleaseException {
        if (isCygwin) {
            this.getLogger().info("detected cygwin:");
            try {
                this.getLogger().info("    - turning off filemode...");
                StoredConfig config = flow.git().getRepository().getConfig();
                config.setBoolean("core", null, "filemode", false);
                config.save();
                config.load();
            }
            catch (IOException e) {
                throw new JGitFlowReleaseException("error configuring filemode for cygwin", e);
            }
            catch (ConfigInvalidException e) {
                throw new JGitFlowReleaseException("error configuring filemode for cygwin", e);
            }
            this.getLogger().info("    - fixing maven prompter...");
            this.prompter.setCygwinTerminal();
        }
    }

    @Override
    public String getReleaseVersion(ReleaseContext ctx, MavenProject rootProject) throws JGitFlowReleaseException {
        Logger log = this.getLogger();
        String defaultVersion = rootProject.getVersion();
        if (log.isDebugEnabled()) {
            log.debug("calculating release version for " + rootProject.getGroupId() + ":" + rootProject.getArtifactId());
            log.debug("defaultVersion is currently: " + defaultVersion);
        }
        if (StringUtils.isNotBlank((String)ctx.getDefaultReleaseVersion())) {
            defaultVersion = ctx.getDefaultReleaseVersion();
            if (log.isDebugEnabled()) {
                log.debug("(ctx change) defaultVersion is currently: " + defaultVersion);
            }
        }
        String suggestedVersion = null;
        String releaseVersion = defaultVersion;
        if (log.isDebugEnabled()) {
            log.debug("releaseVersion is currently: " + releaseVersion);
        }
        while (null == releaseVersion || ArtifactUtils.isSnapshot((String)releaseVersion)) {
            if (log.isDebugEnabled()) {
                log.debug("looping until we find a non-snapshot version...");
            }
            DefaultVersionInfo info = null;
            try {
                info = new DefaultVersionInfo(rootProject.getVersion());
            }
            catch (VersionParseException e) {
                if (ctx.isInteractive()) {
                    try {
                        info = new DefaultVersionInfo("1.0");
                    }
                    catch (VersionParseException e1) {
                        throw new JGitFlowReleaseException("error parsing 1.0 version!!!", e1);
                    }
                }
                throw new JGitFlowReleaseException("error parsing release version: " + e.getMessage(), e);
            }
            suggestedVersion = info.getReleaseVersionString();
            if (log.isDebugEnabled()) {
                log.debug("suggestedVersion: " + suggestedVersion);
            }
            if (ctx.isInteractive()) {
                String message = MessageFormat.format("What is the release version for \"{0}\"? ({1})", rootProject.getName(), ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId()));
                try {
                    releaseVersion = this.prompter.promptNotBlank(message, suggestedVersion);
                    continue;
                }
                catch (PrompterException e) {
                    throw new JGitFlowReleaseException("Error reading version from command line " + e.getMessage(), e);
                }
            }
            releaseVersion = suggestedVersion;
            if (!log.isDebugEnabled()) continue;
            log.debug("setting release version to suggested version: " + suggestedVersion);
        }
        return releaseVersion;
    }

    @Override
    public String getHotfixVersion(ReleaseContext ctx, MavenProject rootProject, String lastRelease) throws JGitFlowReleaseException {
        String projectVersion;
        String defaultVersion = projectVersion = rootProject.getVersion();
        HotfixVersionInfo hotfixInfo = null;
        if (StringUtils.isNotBlank((String)lastRelease) && !ArtifactUtils.isSnapshot((String)lastRelease)) {
            try {
                DefaultVersionInfo projectInfo = new DefaultVersionInfo(projectVersion);
                DefaultVersionInfo lastReleaseInfo = new DefaultVersionInfo(lastRelease);
                String higherVersion = projectVersion;
                if (projectInfo.isSnapshot()) {
                    higherVersion = lastRelease;
                } else if (projectInfo.compareTo((VersionInfo)lastReleaseInfo) < 1) {
                    higherVersion = lastRelease;
                }
                hotfixInfo = new HotfixVersionInfo(higherVersion);
                defaultVersion = hotfixInfo.getHotfixVersionString();
            }
            catch (VersionParseException e) {}
        } else {
            try {
                hotfixInfo = new HotfixVersionInfo(projectVersion);
                defaultVersion = hotfixInfo.getHotfixVersionString();
            }
            catch (VersionParseException e) {
                // empty catch block
            }
        }
        String suggestedVersion = defaultVersion;
        String hotfixVersion = null;
        while (null == suggestedVersion || ArtifactUtils.isSnapshot((String)suggestedVersion)) {
            HotfixVersionInfo info = null;
            try {
                info = new HotfixVersionInfo(rootProject.getVersion());
            }
            catch (VersionParseException e) {
                if (ctx.isInteractive()) {
                    try {
                        info = new HotfixVersionInfo("2.0");
                    }
                    catch (VersionParseException e1) {
                        throw new JGitFlowReleaseException("error parsing 2.0 version!!!", e1);
                    }
                }
                throw new JGitFlowReleaseException("error parsing release version: " + e.getMessage(), e);
            }
            suggestedVersion = info.getDecrementedHotfixVersionString();
        }
        while (null == hotfixVersion || ArtifactUtils.isSnapshot(hotfixVersion)) {
            if (ctx.isInteractive()) {
                String message = MessageFormat.format("What is the hotfix version for \"{0}\"? ({1})", rootProject.getName(), ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId()));
                try {
                    hotfixVersion = this.prompter.promptNotBlank(message, suggestedVersion);
                    continue;
                }
                catch (PrompterException e) {
                    throw new JGitFlowReleaseException("Error reading version from command line " + e.getMessage(), e);
                }
            }
            hotfixVersion = suggestedVersion;
        }
        return hotfixVersion;
    }

    @Override
    public String getDevelopmentVersion(ReleaseContext ctx, MavenProject rootProject) throws JGitFlowReleaseException {
        String defaultVersion = rootProject.getVersion();
        if (StringUtils.isNotBlank((String)ctx.getDefaultDevelopmentVersion())) {
            defaultVersion = ctx.getDefaultDevelopmentVersion();
        }
        String suggestedVersion = null;
        String developmentVersion = defaultVersion;
        while (null == developmentVersion || !ArtifactUtils.isSnapshot((String)developmentVersion)) {
            DefaultVersionInfo info = null;
            try {
                info = new DefaultVersionInfo(rootProject.getVersion());
            }
            catch (VersionParseException e) {
                if (ctx.isInteractive()) {
                    try {
                        info = new DefaultVersionInfo("1.0");
                    }
                    catch (VersionParseException e1) {
                        throw new JGitFlowReleaseException("error parsing 1.0 version!!!", e1);
                    }
                }
                throw new JGitFlowReleaseException("error parsing development version: " + e.getMessage(), e);
            }
            suggestedVersion = info.getNextVersion().getSnapshotVersionString();
            if (ctx.isInteractive()) {
                String message = MessageFormat.format("What is the development version for \"{0}\"? ({1})", rootProject.getName(), ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId()));
                try {
                    developmentVersion = this.prompter.promptNotBlank(message, suggestedVersion);
                    continue;
                }
                catch (PrompterException e) {
                    throw new JGitFlowReleaseException("Error reading version from command line " + e.getMessage(), e);
                }
            }
            developmentVersion = suggestedVersion;
        }
        return developmentVersion;
    }

    @Override
    public Map<String, String> getOriginalVersions(String key, List<MavenProject> reactorProjects) {
        if (!this.originalVersions.containsKey(key)) {
            HashMap<String, String> versions = new HashMap<String, String>();
            for (MavenProject project : reactorProjects) {
                versions.put(ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId()), project.getVersion());
            }
            this.originalVersions.put(key, versions);
        }
        return ImmutableMap.copyOf(this.originalVersions.get(key));
    }

    @Override
    public Map<String, String> getReleaseVersions(String key, List<MavenProject> reactorProjects, ReleaseContext ctx) throws JGitFlowReleaseException {
        Logger log = this.getLogger();
        if (log.isDebugEnabled()) {
            log.debug("getting release versions for key: " + key);
            log.debug("AutoVersionSubmodules: " + ctx.isAutoVersionSubmodules());
        }
        if (!this.releaseVersions.containsKey(key)) {
            HashMap<String, String> versions = new HashMap<String, String>();
            MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
            if (log.isDebugEnabled()) {
                log.debug("root project is snapshot: " + ArtifactUtils.isSnapshot((String)rootProject.getVersion()));
            }
            if (ctx.isAutoVersionSubmodules() && ArtifactUtils.isSnapshot((String)rootProject.getVersion())) {
                String rootProjectId = ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId());
                String rootReleaseVersion = this.getReleaseVersion(ctx, rootProject);
                if (log.isDebugEnabled()) {
                    log.debug("getting release version for root project: " + rootProjectId);
                    log.debug("root release version is: " + rootReleaseVersion);
                }
                versions.put(rootProjectId, rootReleaseVersion);
                for (MavenProject subProject : reactorProjects) {
                    String subProjectId = ArtifactUtils.versionlessKey((String)subProject.getGroupId(), (String)subProject.getArtifactId());
                    versions.put(subProjectId, rootReleaseVersion);
                }
            } else {
                for (MavenProject project : reactorProjects) {
                    String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                    String releaseVersion = this.getReleaseVersion(ctx, project);
                    versions.put(projectId, releaseVersion);
                }
            }
            this.releaseVersions.put(key, versions);
        }
        return ImmutableMap.copyOf(this.releaseVersions.get(key));
    }

    @Override
    public Map<String, String> getHotfixVersions(String key, List<MavenProject> reactorProjects, ReleaseContext ctx, Map<String, String> lastReleaseVersions) throws JGitFlowReleaseException {
        if (!this.hotfixVersions.containsKey(key)) {
            HashMap<String, String> versions = new HashMap<String, String>();
            MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
            if (ctx.isAutoVersionSubmodules()) {
                String rootProjectId = ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId());
                String lastRootRelease = "";
                if (null != lastReleaseVersions) {
                    lastRootRelease = lastReleaseVersions.get(rootProjectId);
                }
                String rootHotfixVersion = this.getHotfixVersion(ctx, rootProject, lastRootRelease);
                versions.put(rootProjectId, rootHotfixVersion);
                for (MavenProject subProject : reactorProjects) {
                    String subProjectId = ArtifactUtils.versionlessKey((String)subProject.getGroupId(), (String)subProject.getArtifactId());
                    versions.put(subProjectId, rootHotfixVersion);
                }
            } else {
                for (MavenProject project : reactorProjects) {
                    String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                    String lastRelease = "";
                    if (null != lastReleaseVersions) {
                        lastRelease = lastReleaseVersions.get(projectId);
                    }
                    String hotfixVersion = this.getHotfixVersion(ctx, project, lastRelease);
                    versions.put(projectId, hotfixVersion);
                }
            }
            this.hotfixVersions.put(key, versions);
        }
        return ImmutableMap.copyOf(this.hotfixVersions.get(key));
    }

    @Override
    public Map<String, String> getDevelopmentVersions(String key, List<MavenProject> reactorProjects, ReleaseContext ctx) throws JGitFlowReleaseException {
        if (!this.developmentVersions.containsKey(key)) {
            HashMap<String, String> versions = new HashMap<String, String>();
            MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
            if (ctx.isAutoVersionSubmodules()) {
                String rootProjectId = ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId());
                String rootDevelopmentVersion = this.getDevelopmentVersion(ctx, rootProject);
                versions.put(rootProjectId, rootDevelopmentVersion);
                for (MavenProject subProject : reactorProjects) {
                    String subProjectId = ArtifactUtils.versionlessKey((String)subProject.getGroupId(), (String)subProject.getArtifactId());
                    versions.put(subProjectId, rootDevelopmentVersion);
                }
            } else {
                for (MavenProject project : reactorProjects) {
                    String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                    String developmentVersion = this.getDevelopmentVersion(ctx, project);
                    versions.put(projectId, developmentVersion);
                }
            }
            this.developmentVersions.put(key, versions);
        }
        return ImmutableMap.copyOf(this.developmentVersions.get(key));
    }

    @Override
    public void ensureOrigin(String defaultRemote, JGitFlow flow) throws JGitFlowReleaseException {
        block10: {
            this.getLogger().info("ensuring origin exists...");
            String newOriginUrl = defaultRemote;
            try {
                StoredConfig config = flow.git().getRepository().getConfig();
                String originUrl = config.getString("remote", "origin", "url");
                if (Strings.isNullOrEmpty((String)originUrl) && !Strings.isNullOrEmpty((String)defaultRemote)) {
                    if (defaultRemote.startsWith("file://")) {
                        File originFile = new File(defaultRemote.substring(7));
                        newOriginUrl = "file://" + originFile.getCanonicalPath();
                    }
                    this.getLogger().info("adding origin from default...");
                    config.setString("remote", "origin", "url", newOriginUrl);
                    config.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
                }
                if (Strings.isNullOrEmpty((String)originUrl) && Strings.isNullOrEmpty((String)newOriginUrl)) break block10;
                if (Strings.isNullOrEmpty((String)config.getString("branch", flow.getMasterBranchName(), "remote"))) {
                    config.setString("branch", flow.getMasterBranchName(), "remote", "origin");
                }
                if (Strings.isNullOrEmpty((String)config.getString("branch", flow.getMasterBranchName(), "merge"))) {
                    config.setString("branch", flow.getMasterBranchName(), "merge", "refs/heads/" + flow.getMasterBranchName());
                }
                if (Strings.isNullOrEmpty((String)config.getString("branch", flow.getDevelopBranchName(), "remote"))) {
                    config.setString("branch", flow.getDevelopBranchName(), "remote", "origin");
                }
                if (Strings.isNullOrEmpty((String)config.getString("branch", flow.getDevelopBranchName(), "merge"))) {
                    config.setString("branch", flow.getDevelopBranchName(), "merge", "refs/heads/" + flow.getDevelopBranchName());
                }
                config.save();
                try {
                    config.load();
                    flow.git().fetch().setRemote("origin").call();
                }
                catch (Exception e) {
                    throw new JGitFlowReleaseException("error configuring remote git repo with url: " + newOriginUrl, e);
                }
            }
            catch (IOException e) {
                throw new JGitFlowReleaseException("error configuring remote git repo with url: " + defaultRemote, e);
            }
        }
    }

    @Override
    public void commitAllChanges(Git git, String message) throws JGitFlowReleaseException {
        try {
            Status status = git.status().call();
            if (!status.isClean()) {
                git.add().addFilepattern(".").call();
                git.commit().setMessage(message).call();
            }
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("error committing changes: " + e.getMessage(), e);
        }
    }

    @Override
    public void commitAllPoms(Git git, List<MavenProject> reactorProjects, String message) throws JGitFlowReleaseException {
        try {
            Status status = git.status().call();
            Repository repository = git.getRepository();
            File repoDir = repository.getDirectory().getParentFile();
            if (!status.isClean()) {
                AddCommand add = git.add();
                MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
                for (MavenProject project : reactorProjects) {
                    String pomPath = this.relativePath(repoDir, project.getFile());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("adding file pattern for poms commit: " + pomPath);
                    }
                    if (isWindows) {
                        pomPath = StringUtils.replace((String)pomPath, (String)"\\", (String)"/");
                    }
                    add.addFilepattern(pomPath);
                }
                add.call();
                git.commit().setMessage(message).call();
            }
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("error committing pom changes: " + e.getMessage(), e);
        }
    }

    private String relativePath(File basedir, File file) {
        String basePath;
        String pomPath = file.getAbsolutePath();
        if (pomPath.regionMatches(true, 0, basePath = basedir.getAbsolutePath(), 0, basePath.length()) && (pomPath = file.getAbsolutePath().substring(basedir.getAbsolutePath().length())).startsWith(File.separator)) {
            pomPath = pomPath.substring(1);
        }
        return pomPath;
    }

    @Override
    public List<String> checkForNonReactorSnapshots(String key, List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        ArrayList snapshots = Lists.newArrayList();
        this.getLogger().info("Checking dependencies and plugins for snapshots ...");
        Map<String, String> originalReactorVersions = this.getOriginalVersions(key, reactorProjects);
        for (MavenProject project : reactorProjects) {
            snapshots.addAll(this.checkProjectForNonReactorSnapshots(project, originalReactorVersions));
        }
        return snapshots;
    }

    private List<String> checkProjectForNonReactorSnapshots(MavenProject project, Map<String, String> originalReactorVersions) throws JGitFlowReleaseException {
        List mgntDependencies;
        String parentSnap;
        ArrayList snapshots = Lists.newArrayList();
        Map artifactMap = ArtifactUtils.artifactMapByVersionlessId((Collection)project.getArtifacts());
        if (project.getParentArtifact() != null && !Strings.isNullOrEmpty((String)(parentSnap = this.checkArtifact(this.getArtifactFromMap(project.getParentArtifact(), artifactMap), originalReactorVersions, "parent")))) {
            snapshots.add(parentSnap);
        }
        try {
            Set dependencyArtifacts = project.createArtifacts(this.artifactFactory, null, null);
            snapshots.addAll(this.checkArtifacts(dependencyArtifacts, originalReactorVersions, "dependency"));
        }
        catch (InvalidDependencyVersionException e) {
            throw new JGitFlowReleaseException("Failed to create dependency artifacts", e);
        }
        DependencyManagement dmgnt = project.getDependencyManagement();
        if (null != dmgnt && null != (mgntDependencies = dmgnt.getDependencies())) {
            for (Dependency dep : mgntDependencies) {
                String depSnap = this.checkArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), originalReactorVersions, "dependency management");
                if (Strings.isNullOrEmpty((String)depSnap)) continue;
                snapshots.add(depSnap);
            }
        }
        Set pluginArtifacts = project.getPluginArtifacts();
        snapshots.addAll(this.checkArtifacts(pluginArtifacts, originalReactorVersions, "plugin"));
        PluginManagement pmgnt = project.getPluginManagement();
        if (null != pmgnt) {
            List mgntPlugins = pmgnt.getPlugins();
            for (Plugin plugin : mgntPlugins) {
                String pluginSnap = this.checkArtifact(plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion(), originalReactorVersions, "plugin management");
                if (Strings.isNullOrEmpty((String)pluginSnap)) continue;
                snapshots.add(pluginSnap);
            }
        }
        Set reportArtifacts = project.getReportArtifacts();
        snapshots.addAll(this.checkArtifacts(reportArtifacts, originalReactorVersions, "report"));
        Set extensionArtifacts = project.getExtensionArtifacts();
        snapshots.addAll(this.checkArtifacts(extensionArtifacts, originalReactorVersions, "extensions"));
        return snapshots;
    }

    private List<String> checkArtifacts(Set<Artifact> artifacts, Map<String, String> originalReactorVersions, String type) {
        ArrayList snapshots = Lists.newArrayList();
        for (Artifact artifact : artifacts) {
            String snap = this.checkArtifact(artifact, originalReactorVersions, type);
            if (Strings.isNullOrEmpty((String)snap)) continue;
            snapshots.add(snap);
        }
        return snapshots;
    }

    private String checkArtifact(Artifact artifact, Map<String, String> originalReactorVersions, String type) {
        boolean isSnapshot;
        String versionlessArtifactKey = ArtifactUtils.versionlessKey((String)artifact.getGroupId(), (String)artifact.getArtifactId());
        boolean bl = isSnapshot = artifact.isSnapshot() && !artifact.getBaseVersion().equals(originalReactorVersions.get(versionlessArtifactKey));
        if (isSnapshot) {
            return type + " - " + versionlessArtifactKey;
        }
        return null;
    }

    private String checkArtifact(String groupId, String artifactId, String version, Map<String, String> originalReactorVersions, String type) {
        boolean isSnapshot;
        String versionlessArtifactKey = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        boolean bl = isSnapshot = ArtifactUtils.isSnapshot((String)version) && !version.equals(originalReactorVersions.get(versionlessArtifactKey));
        if (isSnapshot) {
            return type + " - " + versionlessArtifactKey;
        }
        return null;
    }

    private Artifact getArtifactFromMap(Artifact originalArtifact, Map<String, Artifact> artifactMap) {
        String versionlessId = ArtifactUtils.versionlessKey((Artifact)originalArtifact);
        Artifact checkArtifact = artifactMap.get(versionlessId);
        if (checkArtifact == null) {
            checkArtifact = originalArtifact;
        }
        return checkArtifact;
    }

    @Override
    public String getFeatureStartName(ReleaseContext ctx, JGitFlow flow) throws JGitFlowReleaseException {
        String featureName = StringUtils.defaultString((Object)ctx.getDefaultFeatureName());
        if (ctx.isInteractive()) {
            featureName = this.promptForFeatureName(flow.getFeatureBranchPrefix(), featureName);
        } else if (StringUtils.isBlank((String)featureName)) {
            throw new JGitFlowReleaseException("Missing featureName mojo option.");
        }
        return featureName;
    }

    @Override
    public String getFeatureFinishName(ReleaseContext ctx, JGitFlow flow) throws JGitFlowReleaseException {
        String featureName = StringUtils.defaultString((Object)ctx.getDefaultFeatureName());
        if (StringUtils.isBlank((String)featureName)) {
            String currentBranch = null;
            try {
                currentBranch = flow.git().getRepository().getBranch();
                this.getLogger().debug("Current Branch is: " + currentBranch);
            }
            catch (IOException e) {
                throw new JGitFlowReleaseException(e);
            }
            this.getLogger().debug("Feature Prefix is: " + flow.getFeatureBranchPrefix());
            this.getLogger().debug("Branch starts with feature prefix?: " + currentBranch.startsWith(flow.getFeatureBranchPrefix()));
            if (currentBranch.startsWith(flow.getFeatureBranchPrefix())) {
                featureName = currentBranch.replaceFirst(flow.getFeatureBranchPrefix(), "");
            }
        }
        if (ctx.isInteractive()) {
            ArrayList<String> possibleValues = new ArrayList<String>();
            if (null == featureName) {
                featureName = "";
            }
            try {
                String rheadPrefix = "refs/heads/" + flow.getFeatureBranchPrefix();
                List branches = GitHelper.listBranchesWithPrefix((Git)flow.git(), (String)flow.getFeatureBranchPrefix());
                for (Ref branch : branches) {
                    String simpleName = branch.getName().substring(branch.getName().indexOf(rheadPrefix) + rheadPrefix.length());
                    possibleValues.add(simpleName);
                }
                featureName = this.promptForExistingFeatureName(flow.getFeatureBranchPrefix(), featureName, possibleValues);
            }
            catch (JGitFlowGitAPIException e) {
                throw new JGitFlowReleaseException("Unable to determine feature names", e);
            }
        } else if (StringUtils.isBlank((String)featureName)) {
            throw new JGitFlowReleaseException("Missing featureName mojo option.");
        }
        return featureName;
    }

    private String promptForFeatureName(String prefix, String defaultFeatureName) throws JGitFlowReleaseException {
        String message = "What is the feature branch name? " + prefix;
        String name = "";
        try {
            name = this.prompter.promptNotBlank(message, defaultFeatureName);
        }
        catch (PrompterException e) {
            throw new JGitFlowReleaseException("Error reading feature name from command line " + e.getMessage(), e);
        }
        return name;
    }

    private String promptForExistingFeatureName(String prefix, String defaultFeatureName, List<String> featureBranches) throws JGitFlowReleaseException {
        String message = "What is the feature branch name? " + prefix;
        String name = "";
        try {
            name = this.prompter.promptNumberedList(message, featureBranches, defaultFeatureName);
        }
        catch (PrompterException e) {
            throw new JGitFlowReleaseException("Error reading feature name from command line " + e.getMessage(), e);
        }
        return name;
    }

    @Override
    public boolean setupUserPasswordCredentialsProvider(ReleaseContext ctx, JGitFlowReporter reporter) {
        if (null != System.console()) {
            reporter.debugText(this.getClass().getSimpleName(), "installing ssh console credentials provider");
            CredentialsProvider.setDefault((CredentialsProvider)new ConsoleCredentialsProvider(this.prompter));
            return true;
        }
        return false;
    }

    @Override
    public boolean setupSshCredentialsProvider(ReleaseContext ctx, JGitFlowReporter reporter) {
        if (ctx.isEnableSshAgent()) {
            reporter.debugText(this.getClass().getSimpleName(), "installing ssh-agent credentials provider");
            SshSessionFactory.setInstance((SshSessionFactory)new SshCredentialsProvider());
            return true;
        }
        return false;
    }
}

