/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager;

import com.atlassian.jgitflow.core.InitContext;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.exception.ProjectRewriteException;
import com.atlassian.maven.plugins.jgitflow.exception.ReactorReloadException;
import com.atlassian.maven.plugins.jgitflow.manager.AbstractFlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.rewrite.ArtifactReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ParentReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectChangeset;
import com.atlassian.maven.plugins.jgitflow.rewrite.ProjectReleaseVersionChange;
import com.atlassian.maven.plugins.jgitflow.util.NamingUtil;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.RefSpec;

public class DefaultFlowFeatureManager
extends AbstractFlowReleaseManager {
    @Override
    public void start(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws JGitFlowReleaseException {
        JGitFlow flow = null;
        try {
            flow = JGitFlow.forceInit((File)ctx.getBaseDir(), (InitContext)ctx.getFlowInitContext(), (String)ctx.getDefaultOriginUrl());
            this.projectHelper.fixCygwinIfNeeded(flow);
            this.writeReportHeader(ctx, flow.getReporter());
            this.setupCredentialProviders(ctx, flow.getReporter());
            String featureName = this.startFeature(flow, ctx);
            if (ctx.isEnableFeatureVersions()) {
                this.updateFeaturePomsWithFeatureVersion(featureName, flow, ctx, reactorProjects, session);
            }
            if (ctx.isPushFeatures()) {
                String prefixedBranchName = flow.getFeatureBranchPrefix() + featureName;
                RefSpec branchSpec = new RefSpec(prefixedBranchName);
                flow.git().push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
            }
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting feature: " + e.getMessage(), e);
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error starting feature: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                flow.getReporter().flush();
            }
        }
    }

    @Override
    public void finish(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws JGitFlowReleaseException {
        JGitFlow flow = null;
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        MavenSession currentSession = session;
        try {
            flow = JGitFlow.forceInit((File)ctx.getBaseDir(), (InitContext)ctx.getFlowInitContext(), (String)ctx.getDefaultOriginUrl());
            this.projectHelper.fixCygwinIfNeeded(flow);
            JGitFlowReporter reporter = flow.getReporter();
            this.writeReportHeader(ctx, reporter);
            this.setupCredentialProviders(ctx, reporter);
            if (ctx.isPushFeatures() || ctx.isPullDevelop()) {
                this.projectHelper.ensureOrigin(ctx.getDefaultOriginUrl(), flow);
            }
            if (GitHelper.remoteBranchExists((Git)flow.git(), (String)flow.getDevelopBranchName(), (JGitFlowReporter)flow.getReporter())) {
                if (ctx.isPullDevelop()) {
                    reporter.debugText("finishFeature", "pulling develop before remote behind check");
                    reporter.flush();
                    flow.git().checkout().setName(flow.getDevelopBranchName()).call();
                    flow.git().pull().call();
                }
                if (GitHelper.localBranchBehindRemote((Git)flow.git(), (String)flow.getDevelopBranchName(), (JGitFlowReporter)flow.getReporter())) {
                    reporter.errorText("feature-finish", "local branch '" + flow.getDevelopBranchName() + "' is behind the remote branch");
                    reporter.flush();
                    throw new BranchOutOfDateException("local branch '" + flow.getDevelopBranchName() + "' is behind the remote branch");
                }
            }
            String featureLabel = this.getFeatureFinishName(ctx, flow);
            String prefixedBranchName = flow.getFeatureBranchPrefix() + featureLabel;
            flow.git().checkout().setName(prefixedBranchName).call();
            if (GitHelper.remoteBranchExists((Git)flow.git(), (String)prefixedBranchName, (JGitFlowReporter)reporter) && GitHelper.localBranchBehindRemote((Git)flow.git(), (String)prefixedBranchName, (JGitFlowReporter)reporter)) {
                reporter.errorText("feature-finish", "local branch '" + prefixedBranchName + "' is behind the remote branch");
                reporter.flush();
                throw new BranchOutOfDateException("local branch '" + prefixedBranchName + "' is behind the remote branch");
            }
            if (ctx.isEnableFeatureVersions()) {
                this.updateFeaturePomsWithNonFeatureVersion(featureLabel, flow, ctx, reactorProjects, session);
                MavenSession featureSession = this.getSessionForBranch(flow, prefixedBranchName, reactorProjects, session);
                List featureProjects = featureSession.getSortedProjects();
                currentSession = featureSession;
                rootProject = ReleaseUtil.getRootProject((List)featureProjects);
            }
            if (!ctx.isNoBuild()) {
                try {
                    this.mavenExecutionHelper.execute(rootProject, ctx, currentSession);
                }
                catch (MavenExecutorException e) {
                    throw new JGitFlowReleaseException("Error building: " + e.getMessage(), e);
                }
            }
            this.getLogger().info("running jgitflow feature finish...");
            flow.featureFinish(featureLabel).setKeepBranch(ctx.isKeepBranch()).setSquash(ctx.isSquash()).setRebase(ctx.isFeatureRebase()).setAllowUntracked(ctx.isAllowUntracked()).setPush(ctx.isPushFeatures()).setNoMerge(ctx.isNoFeatureMerge()).setScmMessagePrefix(ctx.getScmCommentPrefix()).call();
            flow.git().checkout().setName(flow.getDevelopBranchName()).call();
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error finish feature: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error finish feature: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error finish feature: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error finish feature: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                flow.getReporter().flush();
            }
        }
    }

    @Override
    public void deploy(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session, String buildNumber, String goals) throws JGitFlowReleaseException {
        JGitFlow flow = null;
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        MavenSession currentSession = session;
        try {
            flow = JGitFlow.forceInit((File)ctx.getBaseDir(), (InitContext)ctx.getFlowInitContext(), (String)ctx.getDefaultOriginUrl());
            this.projectHelper.fixCygwinIfNeeded(flow);
            this.projectHelper.ensureOrigin(ctx.getDefaultOriginUrl(), flow);
            this.writeReportHeader(ctx, flow.getReporter());
            String featureLabel = this.getFeatureFinishName(ctx, flow);
            flow.git().checkout().setName(flow.getFeatureBranchPrefix() + featureLabel).call();
            MavenSession featureSession = this.getSessionForBranch(flow, flow.getFeatureBranchPrefix() + featureLabel, reactorProjects, session);
            List featureProjects = featureSession.getSortedProjects();
            String featureVersion = NamingUtil.camelCaseOrSpaceToDashed(featureLabel);
            featureVersion = StringUtils.replace((String)featureVersion, (String)"-", (String)"_");
            featureVersion = StringUtils.isNotBlank((String)buildNumber) ? featureVersion + "-build" + buildNumber : featureVersion + "-SNAPSHOT";
            this.updatePomsWithFeatureVersionNoSnapshot("featureDeployLabel", featureVersion, ctx, featureProjects);
            rootProject = ReleaseUtil.getRootProject((List)featureProjects);
            featureSession = this.mavenExecutionHelper.reloadReactor(rootProject, session);
            rootProject = ReleaseUtil.getRootProject((List)featureSession.getSortedProjects());
            if (!ctx.isNoBuild()) {
                String mvnGoals = "clean install deploy";
                if (StringUtils.isNotBlank((String)goals)) {
                    mvnGoals = goals;
                }
                try {
                    for (String goal : Splitter.on((String)" ").trimResults().omitEmptyStrings().split((CharSequence)mvnGoals)) {
                        this.mavenExecutionHelper.execute(rootProject, ctx, featureSession, goal);
                    }
                }
                catch (MavenExecutorException e) {
                    throw new JGitFlowReleaseException("Error building: " + e.getMessage(), e);
                }
            }
            flow.git().reset().setMode(ResetCommand.ResetType.HARD).call();
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error finish feature: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error finish feature: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error finish feature: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error finish feature: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                flow.getReporter().flush();
            }
        }
    }

    private String startFeature(JGitFlow flow, ReleaseContext ctx) throws JGitFlowReleaseException {
        String featureName = "";
        try {
            flow.git().checkout().setName(flow.getDevelopBranchName()).call();
            featureName = this.getFeatureStartName(ctx, flow);
            if (ctx.isPushFeatures()) {
                this.projectHelper.ensureOrigin(ctx.getDefaultOriginUrl(), flow);
            }
            flow.featureStart(featureName).setAllowUntracked(ctx.isAllowUntracked()).setPush(ctx.isPushFeatures()).setStartCommit(ctx.getStartCommit()).setScmMessagePrefix(ctx.getScmCommentPrefix()).call();
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting feature: " + e.getMessage(), e);
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error starting feature: " + e.getMessage(), e);
        }
        return featureName;
    }

    private void updateFeaturePomsWithFeatureVersion(String featureName, JGitFlow flow, ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        try {
            MavenSession featureSession = this.getSessionForBranch(flow, flow.getFeatureBranchPrefix() + featureName, originalProjects, session);
            List featureProjects = featureSession.getSortedProjects();
            String featureVersion = NamingUtil.camelCaseOrSpaceToDashed(featureName);
            featureVersion = StringUtils.replace((String)featureVersion, (String)"-", (String)"_");
            this.updatePomsWithFeatureVersion("featureStartLabel", featureVersion, ctx, featureProjects);
            this.projectHelper.commitAllPoms(flow.git(), featureProjects, ctx.getScmCommentPrefix() + "updating poms for " + featureVersion + " version");
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting feature: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error starting feature: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error starting feature: " + e.getMessage(), e);
        }
    }

    private void updateFeaturePomsWithNonFeatureVersion(String featureLabel, JGitFlow flow, ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        try {
            MavenSession featureSession = this.getSessionForBranch(flow, flow.getFeatureBranchPrefix() + featureLabel, originalProjects, session);
            List featureProjects = featureSession.getSortedProjects();
            String featureVersion = NamingUtil.camelCaseOrSpaceToDashed(featureLabel);
            featureVersion = StringUtils.replace((String)featureVersion, (String)"-", (String)"_");
            this.updatePomsWithNonFeatureVersion("featureFinishLabel", featureVersion, ctx, featureProjects);
            this.projectHelper.commitAllPoms(flow.git(), featureProjects, ctx.getScmCommentPrefix() + "updating poms for " + featureVersion + " version");
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error finishing feature: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error finishing feature: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error finishing feature: " + e.getMessage(), e);
        }
    }

    private void updatePomsWithFeatureVersionNoSnapshot(String key, final String featureVersion, ReleaseContext ctx, List<MavenProject> reactorProjects) throws JGitFlowReleaseException {
        Map<String, String> originalVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map<String, String> featureVersions = this.projectHelper.getOriginalVersions(key, reactorProjects);
        Map featureSuffixedVersions = Maps.transformValues(featureVersions, (Function)new Function<String, String>(){

            public String apply(String input) {
                if (input.endsWith("-SNAPSHOT")) {
                    return StringUtils.substringBeforeLast((String)input, (String)"-SNAPSHOT") + "-" + featureVersion;
                }
                return input;
            }
        });
        this.getLogger().info("updating poms for all projects...");
        if (!this.getLogger().isDebugEnabled()) {
            this.getLogger().info("turn on debug logging with -X to see exact changes");
        }
        for (MavenProject project : reactorProjects) {
            ProjectChangeset changes = new ProjectChangeset().with(ParentReleaseVersionChange.parentReleaseVersionChange(originalVersions, featureSuffixedVersions)).with(ProjectReleaseVersionChange.projectReleaseVersionChange(featureSuffixedVersions)).with(ArtifactReleaseVersionChange.artifactReleaseVersionChange(originalVersions, featureSuffixedVersions, ctx.isUpdateDependencies()));
            try {
                this.getLogger().info("updating pom for " + project.getName() + "...");
                this.projectRewriter.applyChanges(project, changes);
                this.logChanges(changes);
            }
            catch (ProjectRewriteException e) {
                throw new JGitFlowReleaseException("Error updating poms with feature versions", e);
            }
        }
    }
}

