/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager;

import com.atlassian.jgitflow.core.InitContext;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.ReleaseMergeResult;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.HotfixBranchExistsException;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.maven.plugins.jgitflow.MavenJGitFlowConfiguration;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.exception.ReactorReloadException;
import com.atlassian.maven.plugins.jgitflow.exception.UnresolvedSnapshotsException;
import com.atlassian.maven.plugins.jgitflow.manager.AbstractFlowReleaseManager;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.RefSpec;

public class DefaultFlowHotfixManager
extends AbstractFlowReleaseManager {
    @Override
    public void start(ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        JGitFlow flow = null;
        MavenJGitFlowConfiguration config = null;
        try {
            flow = JGitFlow.forceInit((File)ctx.getBaseDir(), (InitContext)ctx.getFlowInitContext(), (String)ctx.getDefaultOriginUrl());
            this.projectHelper.fixCygwinIfNeeded(flow);
            this.writeReportHeader(ctx, flow.getReporter());
            this.setupCredentialProviders(ctx, flow.getReporter());
            config = this.configManager.getConfiguration(flow.git());
            String hotfixLabel = this.startHotfix(flow, config, ctx, originalProjects, session);
            this.updateHotfixPomsWithSnapshot(hotfixLabel, flow, ctx, config, originalProjects, session);
            if (ctx.isPushHotfixes()) {
                String prefixedBranchName = flow.getHotfixBranchPrefix() + hotfixLabel;
                RefSpec branchSpec = new RefSpec(prefixedBranchName);
                flow.git().push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
            }
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                flow.getReporter().flush();
            }
        }
        try {
            this.savePreHotfixDevelopVersions(flow, originalProjects, session, config);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void finish(ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        JGitFlow flow = null;
        MavenJGitFlowConfiguration config = null;
        try {
            flow = JGitFlow.forceInit((File)ctx.getBaseDir(), (InitContext)ctx.getFlowInitContext(), (String)ctx.getDefaultOriginUrl());
            this.projectHelper.fixCygwinIfNeeded(flow);
            this.writeReportHeader(ctx, flow.getReporter());
            this.setupCredentialProviders(ctx, flow.getReporter());
            config = this.configManager.getConfiguration(flow.git());
            this.finishHotfix(flow, config, ctx, originalProjects, session);
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error finishing hotfix: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error finishing hotfix: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                flow.getReporter().flush();
            }
        }
    }

    private String startHotfix(JGitFlow flow, MavenJGitFlowConfiguration config, ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        String hotfixLabel = "";
        try {
            List<String> snapshots;
            flow.git().checkout().setName(flow.getMasterBranchName()).call();
            MavenSession masterSession = this.getSessionForBranch(flow, flow.getMasterBranchName(), originalProjects, session);
            List masterProjects = masterSession.getSortedProjects();
            this.checkPomForRelease(masterProjects);
            if (!ctx.isAllowSnapshots() && !(snapshots = this.projectHelper.checkForNonReactorSnapshots("master", masterProjects)).isEmpty()) {
                String details = Joiner.on((String)ls).join(snapshots);
                throw new UnresolvedSnapshotsException("Cannot start a hotfix due to snapshot dependencies:" + ls + details);
            }
            if (ctx.isPushHotfixes() || !ctx.isNoTag()) {
                this.projectHelper.ensureOrigin(ctx.getDefaultOriginUrl(), flow);
            }
            hotfixLabel = this.getHotfixLabel("hotfixlabel", ctx, masterProjects, config);
            flow.hotfixStart(hotfixLabel).setAllowUntracked(ctx.isAllowUntracked()).setPush(ctx.isPushHotfixes()).setStartCommit(ctx.getStartCommit()).setScmMessagePrefix(ctx.getScmCommentPrefix()).call();
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (HotfixBranchExistsException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        return hotfixLabel;
    }

    private void finishHotfix(JGitFlow flow, MavenJGitFlowConfiguration config, ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        String hotfixLabel = "";
        try {
            List<String> snapshots;
            List hotfixBranches;
            JGitFlowReporter reporter = flow.getReporter();
            if (GitHelper.remoteBranchExists((Git)flow.git(), (String)flow.getDevelopBranchName(), (JGitFlowReporter)flow.getReporter())) {
                if (ctx.isPullDevelop()) {
                    reporter.debugText("finishRelease", "pulling develop before remote behind check");
                    reporter.flush();
                    flow.git().checkout().setName(flow.getDevelopBranchName()).call();
                    flow.git().pull().call();
                }
                if (GitHelper.localBranchBehindRemote((Git)flow.git(), (String)flow.getDevelopBranchName(), (JGitFlowReporter)flow.getReporter())) {
                    reporter.errorText("hotfix-finish", "local branch '" + flow.getDevelopBranchName() + "' is behind the remote branch");
                    reporter.flush();
                    throw new BranchOutOfDateException("local branch '" + flow.getDevelopBranchName() + "' is behind the remote branch");
                }
            }
            if ((hotfixBranches = GitHelper.listBranchesWithPrefix((Git)flow.git(), (String)flow.getHotfixBranchPrefix())).isEmpty()) {
                throw new JGitFlowReleaseException("Could not find hotfix branch!");
            }
            String rheadPrefix = "refs/heads/" + flow.getHotfixBranchPrefix();
            Ref hotfixBranch = (Ref)hotfixBranches.get(0);
            hotfixLabel = hotfixBranch.getName().substring(hotfixBranch.getName().indexOf(rheadPrefix) + rheadPrefix.length());
            String prefixedBranchName = flow.getHotfixBranchPrefix() + hotfixLabel;
            flow.git().checkout().setName(prefixedBranchName).call();
            if (GitHelper.remoteBranchExists((Git)flow.git(), (String)prefixedBranchName, (JGitFlowReporter)reporter) && GitHelper.localBranchBehindRemote((Git)flow.git(), (String)prefixedBranchName, (JGitFlowReporter)reporter)) {
                reporter.errorText("hotfix-finish", "local branch '" + prefixedBranchName + "' is behind the remote branch");
                reporter.flush();
                throw new BranchOutOfDateException("local branch '" + prefixedBranchName + "' is behind the remote branch");
            }
            if (GitHelper.remoteBranchExists((Git)flow.git(), (String)flow.getMasterBranchName(), (JGitFlowReporter)flow.getReporter())) {
                if (ctx.isPullMaster()) {
                    reporter.debugText("finishHotfix", "pulling master before remote behind check");
                    reporter.flush();
                    flow.git().checkout().setName(flow.getMasterBranchName()).call();
                    flow.git().pull().call();
                    flow.git().checkout().setName(prefixedBranchName).call();
                }
                if (GitHelper.localBranchBehindRemote((Git)flow.git(), (String)flow.getMasterBranchName(), (JGitFlowReporter)flow.getReporter())) {
                    reporter.errorText("hotfix-finish", "local branch '" + flow.getMasterBranchName() + "' is behind the remote branch");
                    reporter.flush();
                    throw new BranchOutOfDateException("local branch '" + flow.getMasterBranchName() + "' is behind the remote branch");
                }
            }
            MavenSession hotfixSession = this.getSessionForBranch(flow, prefixedBranchName, originalProjects, session);
            List hotfixProjects = hotfixSession.getSortedProjects();
            this.updateHotfixPomsWithRelease(hotfixLabel, flow, ctx, config, originalProjects, session);
            this.projectHelper.commitAllPoms(flow.git(), originalProjects, ctx.getScmCommentPrefix() + "updating poms for " + hotfixLabel + " hotfix");
            hotfixSession = this.getSessionForBranch(flow, prefixedBranchName, originalProjects, session);
            hotfixProjects = hotfixSession.getSortedProjects();
            this.checkPomForRelease(hotfixProjects);
            if (!ctx.isAllowSnapshots() && !(snapshots = this.projectHelper.checkForNonReactorSnapshots("hotfix", hotfixProjects)).isEmpty()) {
                String details = Joiner.on((String)ls).join(snapshots);
                throw new UnresolvedSnapshotsException("Cannot finish a hotfix due to snapshot dependencies:" + ls + details);
            }
            MavenProject rootProject = ReleaseUtil.getRootProject((List)hotfixProjects);
            if (!ctx.isNoBuild()) {
                try {
                    this.mavenExecutionHelper.execute(rootProject, ctx, hotfixSession);
                }
                catch (MavenExecutorException e) {
                    throw new JGitFlowReleaseException("Error building: " + e.getMessage(), e);
                }
            }
            Map<String, String> originalVersions = this.projectHelper.getOriginalVersions("hotfix", hotfixProjects);
            MavenSession developSession = this.getSessionForBranch(flow, flow.getDevelopBranchName(), originalProjects, session);
            List developProjects = developSession.getSortedProjects();
            this.savePreHotfixDevelopVersions(flow, developProjects, config);
            flow.git().checkout().setName(flow.getDevelopBranchName()).call();
            this.updatePomsWithVersionCopy(ctx, developProjects, hotfixProjects);
            flow.git().add().addFilepattern(".").call();
            flow.git().commit().setMessage(ctx.getScmCommentPrefix() + "updating develop with hotfix versions to avoid merge conflicts").call();
            flow.git().checkout().setName(prefixedBranchName);
            if (ctx.isPushHotfixes() || !ctx.isNoTag()) {
                this.projectHelper.ensureOrigin(ctx.getDefaultOriginUrl(), flow);
            }
            this.getLogger().info("running jgitflow hotfix finish...");
            ReleaseMergeResult mergeResult = flow.hotfixFinish(hotfixLabel).setPush(ctx.isPushHotfixes()).setKeepBranch(ctx.isKeepBranch()).setNoTag(ctx.isNoTag()).setMessage(ReleaseUtil.interpolate((String)ctx.getTagMessage(), (Model)rootProject.getModel())).setAllowUntracked(ctx.isAllowUntracked()).setScmMessagePrefix(ctx.getScmCommentPrefix()).call();
            if (!mergeResult.wasSuccessful()) {
                if (mergeResult.masterHasProblems()) {
                    this.getLogger().error("Error merging into " + flow.getMasterBranchName() + ":");
                    this.getLogger().error(mergeResult.getMasterResult().toString());
                    this.getLogger().error("see .git/jgitflow.log for more info");
                }
                if (mergeResult.developHasProblems()) {
                    this.getLogger().error("Error merging into " + flow.getDevelopBranchName() + ":");
                    this.getLogger().error(mergeResult.getDevelopResult().toString());
                    this.getLogger().error("see .git/jgitflow.log for more info");
                }
                throw new JGitFlowReleaseException("Error while merging hotfix!");
            }
            flow.git().checkout().setName(flow.getDevelopBranchName()).call();
            developSession = this.getSessionForBranch(flow, flow.getDevelopBranchName(), originalProjects, session);
            developProjects = developSession.getSortedProjects();
            this.updatePomsWithPreviousVersions("hotfix", ctx, developProjects, config);
            this.projectHelper.commitAllPoms(flow.git(), developProjects, ctx.getScmCommentPrefix() + "updating poms for development");
            config.setLastReleaseVersions(originalVersions);
            this.configManager.saveConfiguration(config, flow.git());
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
        catch (ReleaseExecutionException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
    }

    private void updateHotfixPoms(String hotfixLabel, JGitFlow flow, ReleaseContext ctx, MavenJGitFlowConfiguration config, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        try {
            MavenSession hotfixSession = this.getSessionForBranch(flow, flow.getHotfixBranchPrefix() + hotfixLabel, originalProjects, session);
            List hotfixProjects = hotfixSession.getSortedProjects();
            this.updatePomsWithHotfixVersion("hotfixlabel", ctx, hotfixProjects, config);
            this.projectHelper.commitAllPoms(flow.git(), hotfixProjects, ctx.getScmCommentPrefix() + "updating poms for " + hotfixLabel + " hotfix");
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
    }

    private void updateHotfixPomsWithRelease(String hotfixLabel, JGitFlow flow, ReleaseContext ctx, MavenJGitFlowConfiguration config, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        try {
            MavenSession hotfixSession = this.getSessionForBranch(flow, flow.getHotfixBranchPrefix() + hotfixLabel, originalProjects, session);
            List hotfixProjects = hotfixSession.getSortedProjects();
            this.updatePomsWithHotfixVersion("hotfixlabel", hotfixLabel, ctx, hotfixProjects, config);
            this.projectHelper.commitAllPoms(flow.git(), hotfixProjects, ctx.getScmCommentPrefix() + "updating poms for " + hotfixLabel + " hotfix");
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
    }

    private void updateHotfixPomsWithSnapshot(String hotfixLabel, JGitFlow flow, ReleaseContext ctx, MavenJGitFlowConfiguration config, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        try {
            MavenSession hotfixSession = this.getSessionForBranch(flow, flow.getHotfixBranchPrefix() + hotfixLabel, originalProjects, session);
            List hotfixProjects = hotfixSession.getSortedProjects();
            this.updatePomsWithHotfixSnapshotVersion("hotfixlabel", hotfixLabel, ctx, hotfixProjects, config);
            this.projectHelper.commitAllPoms(flow.git(), hotfixProjects, ctx.getScmCommentPrefix() + "updating poms for " + hotfixLabel + " hotfix");
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error starting hotfix: " + e.getMessage(), e);
        }
    }

    private void savePreHotfixDevelopVersions(JGitFlow flow, List<MavenProject> originalProjects, MavenSession session, MavenJGitFlowConfiguration config) throws IOException, ReactorReloadException, GitAPIException {
        MavenSession developSession = this.getSessionForBranch(flow, flow.getDevelopBranchName(), originalProjects, session);
        List developProjects = developSession.getSortedProjects();
        Map<String, String> originalDevelopVersions = this.projectHelper.getOriginalVersions("develop", developProjects);
        config.setPreHotfixVersions(originalDevelopVersions);
        this.configManager.saveConfiguration(config, flow.git());
    }

    private void savePreHotfixDevelopVersions(JGitFlow flow, List<MavenProject> developProjects, MavenJGitFlowConfiguration config) throws IOException, GitAPIException {
        Map<String, String> originalDevelopVersions = this.projectHelper.getOriginalVersions("develop", developProjects);
        config.setPreHotfixVersions(originalDevelopVersions);
        this.configManager.saveConfiguration(config, flow.git());
    }
}

