/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager;

import com.atlassian.jgitflow.core.InitContext;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.ReleaseMergeResult;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.JGitFlowException;
import com.atlassian.jgitflow.core.exception.ReleaseBranchExistsException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.maven.plugins.jgitflow.MavenJGitFlowConfiguration;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.JGitFlowReleaseException;
import com.atlassian.maven.plugins.jgitflow.exception.ReactorReloadException;
import com.atlassian.maven.plugins.jgitflow.exception.UnresolvedSnapshotsException;
import com.atlassian.maven.plugins.jgitflow.manager.AbstractFlowReleaseManager;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.RefSpec;

public class DefaultFlowReleaseManager
extends AbstractFlowReleaseManager {
    @Override
    public void start(ReleaseContext ctx, List<MavenProject> reactorProjects, MavenSession session) throws JGitFlowReleaseException {
        JGitFlow flow = null;
        try {
            flow = JGitFlow.forceInit((File)ctx.getBaseDir(), (InitContext)ctx.getFlowInitContext(), (String)ctx.getDefaultOriginUrl());
            this.projectHelper.fixCygwinIfNeeded(flow);
            this.writeReportHeader(ctx, flow.getReporter());
            this.setupCredentialProviders(ctx, flow.getReporter());
            String releaseLabel = this.startRelease(flow, ctx, reactorProjects, session);
            this.updateReleasePomsWithSnapshot(releaseLabel, flow, ctx, reactorProjects, session);
            if (ctx.isPushReleases()) {
                String prefixedBranchName = flow.getReleaseBranchPrefix() + releaseLabel;
                RefSpec branchSpec = new RefSpec(prefixedBranchName);
                flow.git().push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
            }
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                flow.getReporter().flush();
            }
        }
    }

    @Override
    public void finish(ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        JGitFlow flow = null;
        MavenJGitFlowConfiguration config = null;
        try {
            flow = JGitFlow.forceInit((File)ctx.getBaseDir(), (InitContext)ctx.getFlowInitContext(), (String)ctx.getDefaultOriginUrl());
            this.projectHelper.fixCygwinIfNeeded(flow);
            this.writeReportHeader(ctx, flow.getReporter());
            this.setupCredentialProviders(ctx, flow.getReporter());
            config = this.configManager.getConfiguration(flow.git());
            if (ctx.isPushReleases() || !ctx.isNoTag()) {
                this.projectHelper.ensureOrigin(ctx.getDefaultOriginUrl(), flow);
            }
            this.finishRelease(flow, config, ctx, originalProjects, session);
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error finishing release: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error finishing release: " + e.getMessage(), e);
        }
        finally {
            if (null != flow) {
                flow.getReporter().flush();
            }
        }
    }

    private String startRelease(JGitFlow flow, ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        String releaseLabel = "";
        try {
            List<String> snapshots;
            flow.git().checkout().setName(flow.getDevelopBranchName()).call();
            MavenSession developSession = this.getSessionForBranch(flow, flow.getDevelopBranchName(), originalProjects, session);
            List developProjects = developSession.getSortedProjects();
            this.checkPomForSnapshot(developProjects);
            if (!ctx.isAllowSnapshots() && !(snapshots = this.projectHelper.checkForNonReactorSnapshots("develop", developProjects)).isEmpty()) {
                String details = Joiner.on((String)ls).join(snapshots);
                throw new UnresolvedSnapshotsException("Cannot start a release due to snapshot dependencies:" + ls + details);
            }
            if (ctx.isPushReleases() || !ctx.isNoTag()) {
                this.projectHelper.ensureOrigin(ctx.getDefaultOriginUrl(), flow);
            }
            releaseLabel = this.getReleaseLabel("releaseStartLabel", ctx, developProjects);
            flow.releaseStart(releaseLabel).setAllowUntracked(ctx.isAllowUntracked()).setPush(ctx.isPushReleases()).setStartCommit(ctx.getStartCommit()).setScmMessagePrefix(ctx.getScmCommentPrefix()).call();
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        catch (ReleaseBranchExistsException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        return releaseLabel;
    }

    private void finishRelease(JGitFlow flow, MavenJGitFlowConfiguration config, ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        String releaseLabel = "";
        try {
            List<String> snapshots;
            List releaseBranches;
            JGitFlowReporter reporter = flow.getReporter();
            if (GitHelper.remoteBranchExists((Git)flow.git(), (String)flow.getDevelopBranchName(), (JGitFlowReporter)flow.getReporter())) {
                if (ctx.isPullDevelop()) {
                    reporter.debugText("finishRelease", "pulling develop before remote behind check");
                    reporter.flush();
                    flow.git().checkout().setName(flow.getDevelopBranchName()).call();
                    flow.git().pull().call();
                }
                if (GitHelper.localBranchBehindRemote((Git)flow.git(), (String)flow.getDevelopBranchName(), (JGitFlowReporter)flow.getReporter())) {
                    reporter.errorText("release-finish", "local branch '" + flow.getDevelopBranchName() + "' is behind the remote branch");
                    reporter.flush();
                    throw new BranchOutOfDateException("local branch '" + flow.getDevelopBranchName() + "' is behind the remote branch");
                }
            }
            if ((releaseBranches = GitHelper.listBranchesWithPrefix((Git)flow.git(), (String)flow.getReleaseBranchPrefix())).isEmpty()) {
                throw new JGitFlowReleaseException("Could not find release branch!");
            }
            String rheadPrefix = "refs/heads/" + flow.getReleaseBranchPrefix();
            Ref releaseBranch = (Ref)releaseBranches.get(0);
            releaseLabel = releaseBranch.getName().substring(releaseBranch.getName().indexOf(rheadPrefix) + rheadPrefix.length());
            String prefixedBranchName = flow.getReleaseBranchPrefix() + releaseLabel;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("checking out release branch: " + prefixedBranchName);
            }
            flow.git().checkout().setName(prefixedBranchName).call();
            if (GitHelper.remoteBranchExists((Git)flow.git(), (String)prefixedBranchName, (JGitFlowReporter)reporter) && GitHelper.localBranchBehindRemote((Git)flow.git(), (String)prefixedBranchName, (JGitFlowReporter)reporter)) {
                reporter.errorText("release-finish", "local branch '" + prefixedBranchName + "' is behind the remote branch");
                reporter.flush();
                throw new BranchOutOfDateException("local branch '" + prefixedBranchName + "' is behind the remote branch");
            }
            if (GitHelper.remoteBranchExists((Git)flow.git(), (String)flow.getMasterBranchName(), (JGitFlowReporter)flow.getReporter())) {
                if (ctx.isPullMaster()) {
                    reporter.debugText("finishRelease", "pulling master before remote behind check");
                    reporter.flush();
                    flow.git().checkout().setName(flow.getMasterBranchName()).call();
                    flow.git().pull().call();
                    flow.git().checkout().setName(prefixedBranchName).call();
                }
                if (GitHelper.localBranchBehindRemote((Git)flow.git(), (String)flow.getMasterBranchName(), (JGitFlowReporter)flow.getReporter())) {
                    reporter.errorText("release-finish", "local branch '" + flow.getMasterBranchName() + "' is behind the remote branch");
                    reporter.flush();
                    throw new BranchOutOfDateException("local branch '" + flow.getMasterBranchName() + "' is behind the remote branch");
                }
            }
            MavenSession releaseSession = this.getSessionForBranch(flow, prefixedBranchName, originalProjects, session);
            List releaseProjects = releaseSession.getSortedProjects();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("updating release poms with release...");
            }
            this.updateReleasePomsWithRelease(releaseLabel, flow, ctx, originalProjects, session);
            this.projectHelper.commitAllPoms(flow.git(), originalProjects, ctx.getScmCommentPrefix() + "updating poms for " + releaseLabel + " release");
            releaseSession = this.getSessionForBranch(flow, prefixedBranchName, originalProjects, session);
            releaseProjects = releaseSession.getSortedProjects();
            this.checkPomForRelease(releaseProjects);
            if (!ctx.isAllowSnapshots() && !(snapshots = this.projectHelper.checkForNonReactorSnapshots("release", releaseProjects)).isEmpty()) {
                String details = Joiner.on((String)ls).join(snapshots);
                throw new UnresolvedSnapshotsException("Cannot finish a release due to snapshot dependencies:" + ls + details);
            }
            MavenProject rootProject = ReleaseUtil.getRootProject((List)releaseProjects);
            if (!ctx.isNoBuild()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("building project...");
                }
                try {
                    this.mavenExecutionHelper.execute(rootProject, ctx, releaseSession);
                }
                catch (MavenExecutorException e) {
                    throw new JGitFlowReleaseException("Error building: " + e.getMessage(), e);
                }
            }
            Map<String, String> originalVersions = this.projectHelper.getOriginalVersions("release", releaseProjects);
            this.getLogger().info("running jgitflow release finish...");
            ReleaseMergeResult mergeResult = flow.releaseFinish(releaseLabel).setPush(ctx.isPushReleases()).setKeepBranch(ctx.isKeepBranch()).setNoTag(ctx.isNoTag()).setSquash(ctx.isSquash()).setMessage(ReleaseUtil.interpolate((String)ctx.getTagMessage(), (Model)rootProject.getModel())).setAllowUntracked(ctx.isAllowUntracked()).setNoMerge(ctx.isNoReleaseMerge()).setScmMessagePrefix(ctx.getScmCommentPrefix()).call();
            if (!mergeResult.wasSuccessful()) {
                if (mergeResult.masterHasProblems()) {
                    this.getLogger().error("Error merging into " + flow.getMasterBranchName() + ":");
                    this.getLogger().error(mergeResult.getMasterResult().toString());
                    this.getLogger().error("see .git/jgitflow.log for more info");
                }
                if (mergeResult.developHasProblems()) {
                    this.getLogger().error("Error merging into " + flow.getDevelopBranchName() + ":");
                    this.getLogger().error(mergeResult.getDevelopResult().toString());
                    this.getLogger().error("see .git/jgitflow.log for more info");
                }
                throw new JGitFlowReleaseException("Error while merging release!");
            }
            flow.git().checkout().setName(flow.getDevelopBranchName()).call();
            MavenSession developSession = this.getSessionForBranch(flow, flow.getDevelopBranchName(), originalProjects, session);
            List developProjects = developSession.getSortedProjects();
            String developLabel = this.getDevelopmentLabel("develop", ctx, developProjects);
            this.updatePomsWithDevelopmentVersion("develop", ctx, developProjects);
            this.projectHelper.commitAllPoms(flow.git(), developProjects, ctx.getScmCommentPrefix() + "updating poms for " + developLabel + " development");
            if (ctx.isPushReleases()) {
                RefSpec developSpec = new RefSpec(ctx.getFlowInitContext().getDevelop());
                flow.git().push().setRemote("origin").setRefSpecs(new RefSpec[]{developSpec}).call();
            }
            config.setLastReleaseVersions(originalVersions);
            this.configManager.saveConfiguration(config, flow.git());
        }
        catch (JGitFlowException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
        catch (ReleaseExecutionException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error releasing: " + e.getMessage(), e);
        }
    }

    private void updateReleasePomsWithSnapshot(String releaseLabel, JGitFlow flow, ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        try {
            MavenSession releaseSession = this.getSessionForBranch(flow, flow.getReleaseBranchPrefix() + releaseLabel, originalProjects, session);
            List releaseProjects = releaseSession.getSortedProjects();
            this.updatePomsWithReleaseSnapshotVersion("releaseStartLabel", releaseLabel, ctx, releaseProjects);
            this.projectHelper.commitAllPoms(flow.git(), releaseProjects, ctx.getScmCommentPrefix() + "updating poms for " + releaseLabel + " release");
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
    }

    private void updateReleasePomsWithRelease(String releaseLabel, JGitFlow flow, ReleaseContext ctx, List<MavenProject> originalProjects, MavenSession session) throws JGitFlowReleaseException {
        try {
            MavenSession releaseSession = this.getSessionForBranch(flow, flow.getReleaseBranchPrefix() + releaseLabel, originalProjects, session);
            List releaseProjects = releaseSession.getSortedProjects();
            this.updatePomsWithReleaseVersion("releaseFinishLabel", releaseLabel, ctx, releaseProjects);
            this.projectHelper.commitAllPoms(flow.git(), releaseProjects, ctx.getScmCommentPrefix() + "updating poms for " + releaseLabel + " release");
        }
        catch (GitAPIException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        catch (ReactorReloadException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JGitFlowReleaseException("Error starting release: " + e.getMessage(), e);
        }
    }
}

