/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.mockmvc;

import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockHttpServletRequest;

public class MockMvcRequest
implements Request {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockMvcRequest.class);
    private final Request delegate;
    private static final BufferedReader EMPTY_BUFFERED_READER = new BufferedReader(new StringReader(""));

    @Deprecated
    public MockMvcRequest(@Nonnull MockHttpServletRequest originalRequest) {
        this.delegate = MockMvcRequest.of(originalRequest);
    }

    @Nonnull
    public String getPath() {
        return this.delegate.getPath();
    }

    @Nonnull
    public Request.Method getMethod() {
        return this.delegate.getMethod();
    }

    @Nonnull
    public Optional<String> getBody() {
        return this.delegate.getBody();
    }

    @Nonnull
    public Collection<String> getQueryParameters() {
        return this.delegate.getQueryParameters();
    }

    @Nonnull
    public Collection<String> getQueryParameterValues(String name) {
        return this.delegate.getQueryParameterValues(name);
    }

    @Nonnull
    public Map<String, Collection<String>> getHeaders() {
        return this.delegate.getHeaders();
    }

    @Nonnull
    public Collection<String> getHeaderValues(String name) {
        return this.delegate.getHeaderValues(name);
    }

    @Nonnull
    public static Request of(@Nonnull MockHttpServletRequest originalRequest) {
        Objects.requireNonNull(originalRequest, "An original request is required");
        SimpleRequest.Builder builder = new SimpleRequest.Builder(originalRequest.getMethod(), originalRequest.getPathInfo()).withBody(MockMvcRequest.getBody(originalRequest));
        Collections.list(originalRequest.getHeaderNames()).forEach(header -> builder.withHeader(header, Collections.list(originalRequest.getHeaders(header))));
        originalRequest.getParameterMap().forEach((key, value) -> builder.withQueryParam(key, value));
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getBody(@Nonnull MockHttpServletRequest mockHttpServletRequest) {
        try (BufferedReader reader = MockMvcRequest.getReader(mockHttpServletRequest);){
            String aux;
            StringBuilder builder = new StringBuilder();
            int lineCount = 0;
            while ((aux = reader.readLine()) != null) {
                builder.append(aux);
                ++lineCount;
            }
            if (lineCount <= 0) return null;
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            LOGGER.warn("Can't read request body.", (Throwable)e);
        }
        return null;
    }

    private static BufferedReader getReader(@Nonnull MockHttpServletRequest mockHttpServletRequest) throws UnsupportedEncodingException {
        BufferedReader reader = mockHttpServletRequest.getReader();
        return reader != null ? reader : EMPTY_BUFFERED_READER;
    }
}

