/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.mockmvc;

import com.atlassian.oai.validator.SwaggerRequestResponseValidator;
import com.atlassian.oai.validator.mockmvc.MockMvcRequest;
import com.atlassian.oai.validator.mockmvc.MockMvcResponse;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.report.ValidationReportFormatter;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.ResultMatcher;

public class SwaggerMatchers {
    public ResultMatcher isValid(String swaggerJsonUrlOrPayload) {
        SwaggerRequestResponseValidator validator = SwaggerRequestResponseValidator.createFor((String)swaggerJsonUrlOrPayload).build();
        return result -> {
            MockHttpServletRequest request = result.getRequest();
            MockHttpServletResponse response = result.getResponse();
            ValidationReport validationReport = validator.validate(MockMvcRequest.of(request), MockMvcResponse.of(response));
            if (validationReport.hasErrors()) {
                throw new SwaggerValidationException(validationReport);
            }
        };
    }

    public static class SwaggerValidationException
    extends RuntimeException {
        public SwaggerValidationException(ValidationReport report) {
            super(ValidationReportFormatter.format((ValidationReport)report));
        }
    }
}

