/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.mockmvc;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.mockmvc.MockMvcRequest;
import com.atlassian.oai.validator.mockmvc.MockMvcResponse;
import com.atlassian.oai.validator.report.JsonValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.ResultMatcher;

public class OpenApiMatchers {
    public ResultMatcher isValid(String specUrlOrPayload) {
        OpenApiInteractionValidator validator = OpenApiInteractionValidator.createFor((String)specUrlOrPayload).build();
        return this.isValid(validator);
    }

    public ResultMatcher isValid(OpenApiInteractionValidator validator) {
        return result -> {
            MockHttpServletRequest request = result.getRequest();
            MockHttpServletResponse response = result.getResponse();
            ValidationReport validationReport = validator.validate(MockMvcRequest.of(request), MockMvcResponse.of(response));
            if (validationReport.hasErrors()) {
                throw new OpenApiValidationException(validationReport);
            }
        };
    }

    public static class OpenApiValidationException
    extends RuntimeException {
        private final ValidationReport report;

        public OpenApiValidationException(ValidationReport report) {
            super(JsonValidationReportFormat.getInstance().apply(report));
            this.report = report;
        }

        public ValidationReport getValidationReport() {
            return this.report;
        }
    }
}

