/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.restassured;

import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.model.SimpleResponse;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class RestAssuredResponse
implements Response {
    private final Response delegate;

    @Deprecated
    public RestAssuredResponse(@Nonnull io.restassured.response.Response originalResponse) {
        this.delegate = RestAssuredResponse.of(originalResponse);
    }

    public int getStatus() {
        return this.delegate.getStatus();
    }

    @Nonnull
    public Optional<String> getBody() {
        return this.delegate.getBody();
    }

    @Nonnull
    public Collection<String> getHeaderValues(String name) {
        return this.delegate.getHeaderValues(name);
    }

    @Nonnull
    public static Response of(@Nonnull io.restassured.response.Response originalResponse) {
        Objects.requireNonNull(originalResponse, "An original response is required");
        SimpleResponse.Builder builder = new SimpleResponse.Builder(originalResponse.getStatusCode()).withBody(originalResponse.getBody().asString());
        if (originalResponse.getHeaders() != null) {
            originalResponse.getHeaders().forEach(header -> builder.withHeader(header.getName(), new String[]{header.getValue()}));
        }
        return builder.build();
    }
}

