/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.restassured;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.report.JsonValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.restassured.RestAssuredRequest;
import com.atlassian.oai.validator.restassured.RestAssuredResponse;
import com.atlassian.oai.validator.util.StringUtils;
import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.response.Response;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.util.Objects;

public class OpenApiValidationFilter
implements Filter {
    private final OpenApiInteractionValidator validator;

    public OpenApiValidationFilter(String specUrlOrDefinition) {
        StringUtils.requireNonEmpty((String)specUrlOrDefinition, (String)"A spec is required");
        this.validator = OpenApiInteractionValidator.createFor((String)specUrlOrDefinition).build();
    }

    public OpenApiValidationFilter(OpenApiInteractionValidator validator) {
        Objects.requireNonNull(validator, "A validator is required");
        this.validator = validator;
    }

    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        Response response = ctx.next(requestSpec, responseSpec);
        ValidationReport validationReport = this.validator.validate(RestAssuredRequest.of(requestSpec), RestAssuredResponse.of(response));
        if (validationReport.hasErrors()) {
            throw new OpenApiValidationException(validationReport);
        }
        return response;
    }

    public static class OpenApiValidationException
    extends RuntimeException {
        private final ValidationReport report;

        public OpenApiValidationException(ValidationReport report) {
            super(JsonValidationReportFormat.getInstance().apply(report));
            this.report = report;
        }

        public ValidationReport getValidationReport() {
            return this.report;
        }
    }
}

