/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class ResettableRequestServletWrapper
extends HttpServletRequestWrapper {
    private CachingServletInputStream servletInputStream;
    private BufferedReader reader;
    private Long contentLengthLong;

    public ResettableRequestServletWrapper(HttpServletRequest request) {
        super(request);
    }

    public void resetInputStream() {
        if (this.servletInputStream != null) {
            this.servletInputStream.reset();
            this.reader = null;
            if (this.servletInputStream.isExhausted()) {
                this.contentLengthLong = this.servletInputStream.getContentLength();
            }
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.servletInputStream == null) {
            this.servletInputStream = new CachingServletInputStream(super.getInputStream());
        }
        return this.servletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            String encoding = super.getCharacterEncoding();
            InputStreamReader streamReader = encoding == null ? new InputStreamReader((InputStream)this.getInputStream()) : new InputStreamReader((InputStream)this.getInputStream(), encoding);
            this.reader = new BufferedReader(streamReader);
        }
        return this.reader;
    }

    public int getContentLength() {
        return this.contentLengthLong == null ? super.getContentLength() : (this.contentLengthLong <= Integer.MAX_VALUE ? this.contentLengthLong.intValue() : -1);
    }

    public long getContentLengthLong() {
        return this.contentLengthLong == null ? super.getContentLengthLong() : this.contentLengthLong.longValue();
    }

    private static class CachingServletInputStream
    extends ServletInputStream {
        private static final int CHUNK_SIZE = 8192;
        private final ServletInputStream originalServletInputStream;
        private final List<byte[]> cachedContent = new ArrayList<byte[]>();
        private long count = 0L;
        private long pos = 0L;
        private boolean exhausted = false;

        private CachingServletInputStream(ServletInputStream originalServletInputStream) {
            this.originalServletInputStream = originalServletInputStream;
        }

        private boolean isExhausted() {
            return this.exhausted;
        }

        private Long getContentLength() {
            return this.exhausted ? Long.valueOf(this.count) : null;
        }

        public boolean isFinished() {
            return this.pos >= this.count && this.exhausted;
        }

        public boolean isReady() {
            return this.pos < this.count || this.originalServletInputStream.isReady();
        }

        public void setReadListener(ReadListener readListener) {
            this.originalServletInputStream.setReadListener(readListener);
        }

        public synchronized int read() throws IOException {
            if (this.pos >= this.count && this.exhausted) {
                return -1;
            }
            if (this.pos < this.count) {
                return Byte.toUnsignedInt(this.getChunkForCurrentPos()[(int)(this.pos++ % 8192L)]);
            }
            int value = this.originalServletInputStream.read();
            if (value == -1) {
                this.exhausted = true;
                return -1;
            }
            int index = (int)(this.count % 8192L);
            this.getLatestChunk((int)index)[index] = (byte)value;
            ++this.count;
            ++this.pos;
            return value;
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int length;
            if (this.pos >= this.count && this.exhausted) {
                return -1;
            }
            if (len == 0) {
                return 0;
            }
            if (this.pos < this.count) {
                int result;
                int length2;
                for (result = 0; result < len && this.pos < this.count; result += length2) {
                    int index = (int)this.pos % 8192;
                    length2 = (int)Math.min((long)(8192 - index), Math.min((long)(len - result), this.count - this.pos));
                    System.arraycopy(this.getChunkForCurrentPos(), index, b, off + result, length2);
                    this.pos += (long)length2;
                }
                return result;
            }
            int bytesRead = this.originalServletInputStream.read(b, off, len);
            if (bytesRead == -1) {
                this.exhausted = true;
                return -1;
            }
            for (int i = 0; i < bytesRead; i += length) {
                int index = (int)this.pos % 8192;
                length = Math.min(8192 - index, bytesRead - i);
                System.arraycopy(b, off + i, this.getLatestChunk(index), index, length);
                this.count += (long)length;
                this.pos += (long)length;
            }
            return bytesRead;
        }

        public synchronized void reset() {
            this.pos = 0L;
        }

        private byte[] getChunkForCurrentPos() {
            return this.cachedContent.get((int)(this.pos / 8192L));
        }

        private byte[] getLatestChunk(int remainder) {
            if (remainder == 0) {
                this.cachedContent.add(new byte[8192]);
            }
            return this.cachedContent.get(this.cachedContent.size() - 1);
        }
    }
}

