/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import com.atlassian.oai.validator.springmvc.ResettableRequestServletWrapper;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class OpenApiValidationFilter
extends OncePerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiValidationFilter.class);
    private final boolean validateRequests;
    private final boolean validateResponses;

    public OpenApiValidationFilter() {
        this(true, false);
    }

    public OpenApiValidationFilter(boolean validateRequests, boolean validateResponses) {
        this.validateRequests = validateRequests;
        this.validateResponses = validateResponses;
    }

    protected void doFilterInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest requestToUse = this.wrapValidatableServletRequest(servletRequest);
        HttpServletResponse responseToUse = this.wrapValidatableServletResponse(servletRequest, servletResponse);
        filterChain.doFilter((ServletRequest)requestToUse, (ServletResponse)responseToUse);
        if (responseToUse instanceof ContentCachingResponseWrapper) {
            ((ContentCachingResponseWrapper)responseToUse).copyBodyToResponse();
        }
    }

    private HttpServletRequest wrapValidatableServletRequest(HttpServletRequest servletRequest) {
        boolean doValidationStep = this.validateRequests && OpenApiValidationFilter.getContentLength(servletRequest) <= Integer.MAX_VALUE && !CorsUtils.isPreFlightRequest((HttpServletRequest)servletRequest);
        return doValidationStep ? new ResettableRequestServletWrapper(servletRequest) : servletRequest;
    }

    private HttpServletResponse wrapValidatableServletResponse(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        boolean doValidationStep = this.validateResponses && !CorsUtils.isPreFlightRequest((HttpServletRequest)servletRequest);
        return doValidationStep ? new ContentCachingResponseWrapper(servletResponse) : servletResponse;
    }

    private static long getContentLength(HttpServletRequest servletRequest) {
        String contentLength = servletRequest.getHeader("content-length");
        if (StringUtils.isNotBlank((CharSequence)contentLength)) {
            try {
                return Long.parseLong(contentLength);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid content-length header value on request: '" + contentLength + "'");
            }
        }
        return -1L;
    }
}

