/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.springmvc.DefaultValidationReportHandler;
import com.atlassian.oai.validator.springmvc.InvalidResponseException;
import com.atlassian.oai.validator.springmvc.OpenApiValidationService;
import com.atlassian.oai.validator.springmvc.ResettableRequestServletWrapper;
import com.atlassian.oai.validator.springmvc.ValidationReportHandler;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class OpenApiValidationInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiValidationInterceptor.class);
    protected final OpenApiValidationService openApiValidationService;
    private final ValidationReportHandler validationReportHandler;

    public OpenApiValidationInterceptor(@Nonnull EncodedResource apiSpecification) throws IOException {
        this(new OpenApiValidationService(apiSpecification));
    }

    public OpenApiValidationInterceptor(@Nonnull OpenApiInteractionValidator validator) {
        this(new OpenApiValidationService(validator));
    }

    public OpenApiValidationInterceptor(@Nonnull OpenApiValidationService openApiValidationService) {
        this(openApiValidationService, new DefaultValidationReportHandler());
    }

    public OpenApiValidationInterceptor(@Nonnull OpenApiValidationService openApiValidationService, @Nonnull ValidationReportHandler validationReportHandler) {
        Objects.requireNonNull(openApiValidationService, "openApiValidationService must not be null");
        Objects.requireNonNull(validationReportHandler, "validationReportHandler must not be null");
        this.openApiValidationService = openApiValidationService;
        this.validationReportHandler = validationReportHandler;
    }

    public boolean preHandle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler) throws Exception {
        if (!(servletRequest instanceof ResettableRequestServletWrapper)) {
            LOG.debug("OpenAPI request validation disabled");
            return true;
        }
        ResettableRequestServletWrapper resettableRequest = (ResettableRequestServletWrapper)servletRequest;
        String requestLoggingKey = servletRequest.getMethod() + "#" + servletRequest.getRequestURI();
        LOG.debug("OpenAPI request validation: {}", (Object)requestLoggingKey);
        Request request = this.openApiValidationService.buildRequest((HttpServletRequest)resettableRequest);
        ValidationReport validationReport = this.openApiValidationService.validateRequest(request);
        this.validationReportHandler.handleRequestReport(requestLoggingKey, validationReport);
        resettableRequest.resetInputStream();
        return true;
    }

    public void postHandle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler, ModelAndView modelAndView) throws Exception {
        if (!(servletResponse instanceof ContentCachingResponseWrapper)) {
            LOG.debug("OpenAPI response validation disabled");
            return;
        }
        ContentCachingResponseWrapper cachedResponse = (ContentCachingResponseWrapper)servletResponse;
        String requestLoggingKey = servletRequest.getMethod() + "#" + servletRequest.getRequestURI();
        LOG.debug("OpenAPI response validation: {}", (Object)requestLoggingKey);
        Response response = this.openApiValidationService.buildResponse(cachedResponse);
        ValidationReport validationReport = this.openApiValidationService.validateResponse(servletRequest, response);
        try {
            this.validationReportHandler.handleResponseReport(requestLoggingKey, validationReport);
        }
        catch (InvalidResponseException e) {
            cachedResponse.reset();
            throw e;
        }
    }
}

