/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.model.SimpleResponse;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.springmvc.SpringMVCLevelResolverFactory;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.web.util.ContentCachingResponseWrapper;

class OpenApiValidationService {
    private final OpenApiInteractionValidator validator;

    OpenApiValidationService(EncodedResource specUrlOrPayload) throws IOException {
        this(OpenApiInteractionValidator.createFor((String)OpenApiValidationService.readReader(specUrlOrPayload.getReader())).withLevelResolver(SpringMVCLevelResolverFactory.create()).build());
    }

    OpenApiValidationService(OpenApiInteractionValidator validator) {
        Objects.requireNonNull(validator, "An OpenAPI validator is required.");
        this.validator = validator;
    }

    Request buildRequest(HttpServletRequest servletRequest) throws IOException {
        Objects.requireNonNull(servletRequest, "A request is required.");
        Request.Method method = Request.Method.valueOf((String)servletRequest.getMethod());
        String path = servletRequest.getServletPath();
        SimpleRequest.Builder builder = new SimpleRequest.Builder(method, path);
        String body = OpenApiValidationService.readReader(servletRequest.getReader());
        if (servletRequest.getContentLength() >= 0 || body != null && !body.isEmpty()) {
            builder.withBody(body);
        }
        for (String queryParameterName : OpenApiValidationService.getQueryParameterNames(servletRequest)) {
            builder.withQueryParam(queryParameterName, servletRequest.getParameterValues(queryParameterName));
        }
        for (String headerName : Collections.list(servletRequest.getHeaderNames())) {
            builder.withHeader(headerName, Collections.list(servletRequest.getHeaders(headerName)));
        }
        return builder.build();
    }

    Response buildResponse(ContentCachingResponseWrapper servletResponse) throws IOException {
        int statusCode = servletResponse.getStatusCode();
        SimpleResponse.Builder builder = new SimpleResponse.Builder(statusCode).withBody(new String(servletResponse.getContentAsByteArray(), servletResponse.getCharacterEncoding())).withContentType(servletResponse.getContentType());
        for (String headerName : servletResponse.getHeaderNames()) {
            builder.withHeader(headerName, (List)Lists.newArrayList((Iterable)servletResponse.getHeaders(headerName)));
        }
        return builder.build();
    }

    ValidationReport validateRequest(Request request) {
        return this.validator.validateRequest(request);
    }

    ValidationReport validateResponse(HttpServletRequest servletRequest, Response response) {
        Request.Method method = Request.Method.valueOf((String)servletRequest.getMethod());
        String path = servletRequest.getServletPath();
        return this.validator.validateResponse(path, method, response);
    }

    private static String readReader(Reader reader) throws IOException {
        try (Reader reassignedReader = reader;){
            String string = IOUtils.toString((Reader)reassignedReader);
            return string;
        }
    }

    private static Set<String> getQueryParameterNames(HttpServletRequest servletRequest) {
        return Stream.of(StringUtils.split((String)((String)StringUtils.defaultIfBlank((CharSequence)servletRequest.getQueryString(), (CharSequence)"")), (String)"&")).map(str -> StringUtils.split((String)str, (String)"=")[0]).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
    }
}

