/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ResettableRequestServletWrapper
extends HttpServletRequestWrapper {
    private ServletInputStream servletInputStream;
    private BufferedReader reader;

    ResettableRequestServletWrapper(HttpServletRequest request) {
        super(request);
    }

    public void resetInputStream() throws IOException {
        if (this.servletInputStream == null) {
            this.servletInputStream = new CachedServletInputStream(new byte[0]);
        } else if (this.servletInputStream instanceof WrappedOriginalServletInputStream) {
            byte[] bytes = ((WrappedOriginalServletInputStream)this.servletInputStream).byteArrayOutputStream.toByteArray();
            this.servletInputStream = new CachedServletInputStream(bytes);
        } else if (this.servletInputStream instanceof CachedServletInputStream) {
            this.servletInputStream.reset();
        }
        this.reader = null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.servletInputStream == null) {
            this.servletInputStream = new WrappedOriginalServletInputStream(super.getInputStream(), super.getContentLength());
        }
        return this.servletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            String encoding = super.getCharacterEncoding();
            InputStreamReader streamReader = encoding == null ? new InputStreamReader((InputStream)this.getInputStream()) : new InputStreamReader((InputStream)this.getInputStream(), encoding);
            this.reader = new BufferedReader(streamReader);
        }
        return this.reader;
    }

    private static class CachedServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        private CachedServletInputStream(byte[] bytes) {
            this.inputStream = new ByteArrayInputStream(bytes);
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        public boolean isFinished() {
            return this.inputStream.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new IllegalStateException("Can't set ReadListener on CachedServletInputStream.");
        }

        public void reset() {
            this.inputStream.reset();
        }
    }

    private static class WrappedOriginalServletInputStream
    extends ServletInputStream {
        private final ServletInputStream originalServletInputStream;
        private final ByteArrayOutputStream byteArrayOutputStream;

        private WrappedOriginalServletInputStream(ServletInputStream originalServletInputStream, int contentLength) {
            this.originalServletInputStream = originalServletInputStream;
            this.byteArrayOutputStream = new ByteArrayOutputStream(contentLength > 0 ? contentLength : 1024);
        }

        public boolean isFinished() {
            return this.originalServletInputStream.isFinished();
        }

        public boolean isReady() {
            return this.originalServletInputStream.isReady();
        }

        public void setReadListener(ReadListener readListener) {
            this.originalServletInputStream.setReadListener(readListener);
        }

        public int read() throws IOException {
            int value = this.originalServletInputStream.read();
            if (value != -1) {
                this.byteArrayOutputStream.write(value);
            }
            return value;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.originalServletInputStream.read(b, off, len);
            if (result > 0) {
                this.byteArrayOutputStream.write(b, off, result);
            }
            return result;
        }
    }
}

