/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import com.atlassian.oai.validator.springmvc.ResettableRequestServletWrapper;
import com.atlassian.oai.validator.util.ContentTypeUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.web.cors.CorsUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class OpenApiValidationFilter
extends OncePerRequestFilter {
    static final String ATTRIBUTE_REQUEST_VALIDATION = ClassUtils.getPackageName(OpenApiValidationFilter.class) + ".requestValidation";
    static final String ATTRIBUTE_RESPONSE_VALIDATION = ClassUtils.getPackageName(OpenApiValidationFilter.class) + ".responseValidation";
    private final boolean validateRequests;
    private final boolean validateResponses;

    public OpenApiValidationFilter() {
        this(true, false);
    }

    public OpenApiValidationFilter(boolean validateRequests, boolean validateResponses) {
        this.validateRequests = validateRequests;
        this.validateResponses = validateResponses;
    }

    protected void doFilterInternal(HttpServletRequest servletRequest, HttpServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        HttpServletRequest requestToUse = this.wrapValidatableServletRequest(servletRequest);
        HttpServletResponse responseToUse = this.wrapValidatableServletResponse(servletRequest, servletResponse);
        filterChain.doFilter((ServletRequest)requestToUse, (ServletResponse)responseToUse);
        if (responseToUse instanceof ContentCachingResponseWrapper) {
            ((ContentCachingResponseWrapper)responseToUse).copyBodyToResponse();
        }
    }

    private HttpServletRequest wrapValidatableServletRequest(HttpServletRequest servletRequest) {
        boolean doValidationStep = this.validateRequests && !CorsUtils.isPreFlightRequest((HttpServletRequest)servletRequest);
        servletRequest.setAttribute(ATTRIBUTE_REQUEST_VALIDATION, (Object)doValidationStep);
        if (!doValidationStep) {
            return servletRequest;
        }
        if (ContentTypeUtils.isFormDataContentType((String)servletRequest.getContentType())) {
            return servletRequest instanceof ContentCachingRequestWrapper ? servletRequest : new ContentCachingRequestWrapper(servletRequest);
        }
        return new ResettableRequestServletWrapper(servletRequest);
    }

    private HttpServletResponse wrapValidatableServletResponse(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        boolean doValidationStep = this.validateResponses && !CorsUtils.isPreFlightRequest((HttpServletRequest)servletRequest);
        servletRequest.setAttribute(ATTRIBUTE_RESPONSE_VALIDATION, (Object)doValidationStep);
        if (!doValidationStep) {
            return servletResponse;
        }
        return servletResponse instanceof ContentCachingResponseWrapper ? servletResponse : new ContentCachingResponseWrapper(servletResponse);
    }
}

