/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.model.SimpleResponse;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.springmvc.SpringMVCLevelResolverFactory;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.UrlPathHelper;

class OpenApiValidationService {
    private static final List<String> URI_CHARSETS = OpenApiValidationService.resolveAvailableCharsets();
    private final OpenApiInteractionValidator validator;
    private final UrlPathHelper urlPathHelper;

    OpenApiValidationService(EncodedResource specAsResource, UrlPathHelper urlPathHelper) throws IOException {
        this(OpenApiInteractionValidator.createForInlineApiSpecification((String)IOUtils.toString((Reader)specAsResource.getReader())).withLevelResolver(SpringMVCLevelResolverFactory.create()).build(), urlPathHelper);
    }

    OpenApiValidationService(OpenApiInteractionValidator validator, UrlPathHelper urlPathHelper) {
        Objects.requireNonNull(validator, "An OpenAPI validator is required.");
        this.validator = validator;
        this.urlPathHelper = urlPathHelper;
    }

    private static List<String> resolveAvailableCharsets() {
        List<String> uriCharsets = Charset.availableCharsets().values().stream().map(Charset::name).collect(Collectors.toList());
        uriCharsets.remove(StandardCharsets.UTF_8.name());
        uriCharsets.add(0, StandardCharsets.UTF_8.name());
        return uriCharsets;
    }

    private String resolveServletPath(HttpServletRequest servletRequest) {
        return this.urlPathHelper.getPathWithinApplication(servletRequest);
    }

    Request buildRequest(HttpServletRequest servletRequest) throws IOException {
        Set<String> queryParameterNames;
        Objects.requireNonNull(servletRequest, "A request is required.");
        Request.Method method = Request.Method.valueOf((String)servletRequest.getMethod());
        String path = this.resolveServletPath(servletRequest);
        SimpleRequest.Builder builder = new SimpleRequest.Builder(method, path);
        if (servletRequest instanceof ContentCachingRequestWrapper) {
            ContentCachingRequestWrapper wrappedRequest = (ContentCachingRequestWrapper)servletRequest;
            queryParameterNames = OpenApiValidationService.getQueryParameterNames(servletRequest);
            builder.withBody(wrappedRequest.getContentAsByteArray());
        } else {
            builder.withBody((InputStream)servletRequest.getInputStream());
            queryParameterNames = OpenApiValidationService.getQueryParameterNames(servletRequest);
        }
        for (String queryParameterName : queryParameterNames) {
            builder.withQueryParam(queryParameterName, servletRequest.getParameterValues(queryParameterName));
        }
        for (String headerName : Collections.list(servletRequest.getHeaderNames())) {
            builder.withHeader(headerName, Collections.list(servletRequest.getHeaders(headerName)));
        }
        return builder.build();
    }

    Response buildResponse(ContentCachingResponseWrapper servletResponse) {
        int statusCode = servletResponse.getStatusCode();
        SimpleResponse.Builder builder = new SimpleResponse.Builder(statusCode).withBody(servletResponse.getContentAsByteArray()).withContentType(servletResponse.getContentType());
        for (String headerName : servletResponse.getHeaderNames()) {
            builder.withHeader(headerName, (List)Lists.newArrayList((Iterable)servletResponse.getHeaders(headerName)));
        }
        return builder.build();
    }

    ValidationReport validateRequest(Request request) {
        return this.validator.validateRequest(request);
    }

    ValidationReport validateResponse(HttpServletRequest servletRequest, Response response) {
        Request.Method method = Request.Method.valueOf((String)servletRequest.getMethod());
        String path = this.resolveServletPath(servletRequest);
        return this.validator.validateResponse(path, method, response);
    }

    private static Set<String> getQueryParameterNames(HttpServletRequest servletRequest) {
        ArrayList allAvailableNames = Collections.list(servletRequest.getParameterNames());
        return Stream.of(StringUtils.split((String)((String)StringUtils.defaultIfBlank((CharSequence)servletRequest.getQueryString(), (CharSequence)"")), (String)"&")).map(str -> OpenApiValidationService.uriDecodeParamName(allAvailableNames, StringUtils.split((String)str, (String)"=")[0])).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
    }

    private static String uriDecodeParamName(List<String> allParameterNames, String paramName) {
        if (!allParameterNames.contains(paramName)) {
            for (String charset : URI_CHARSETS) {
                String decoded = OpenApiValidationService.uriDecode(paramName, charset);
                if (!allParameterNames.contains(decoded)) continue;
                return decoded;
            }
        }
        return paramName;
    }

    private static String uriDecode(String paramName, String charset) {
        try {
            return URLDecoder.decode(paramName, charset);
        }
        catch (UnsupportedEncodingException e) {
            return paramName;
        }
    }
}

