/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Body;
import com.atlassian.oai.validator.model.ByteArrayBody;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.springmvc.DefaultValidationReportHandler;
import com.atlassian.oai.validator.springmvc.InvalidResponseException;
import com.atlassian.oai.validator.springmvc.OpenApiValidationContentCachingResponseWrapper;
import com.atlassian.oai.validator.springmvc.OpenApiValidationFilter;
import com.atlassian.oai.validator.springmvc.OpenApiValidationService;
import com.atlassian.oai.validator.springmvc.ResettableInputStreamBody;
import com.atlassian.oai.validator.springmvc.ResettableRequestServletWrapper;
import com.atlassian.oai.validator.springmvc.ResponseUtils;
import com.atlassian.oai.validator.springmvc.ValidationReportHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.UrlPathHelper;

public class OpenApiValidationInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiValidationInterceptor.class);
    private static final String ATTRIBUTE_ALREADY_SET_HEADERS = ClassUtils.getPackageName(OpenApiValidationInterceptor.class) + ".alreadySetHeaders";
    protected final OpenApiValidationService openApiValidationService;
    private final ValidationReportHandler validationReportHandler;

    public OpenApiValidationInterceptor(@Nonnull EncodedResource apiSpecification) throws IOException {
        this(new OpenApiValidationService(apiSpecification, new UrlPathHelper()));
    }

    public OpenApiValidationInterceptor(@Nonnull OpenApiInteractionValidator validator) {
        this(new OpenApiValidationService(validator, new UrlPathHelper()));
    }

    public OpenApiValidationInterceptor(@Nonnull OpenApiInteractionValidator validator, @Nonnull ValidationReportHandler validationReportHandler) {
        this(new OpenApiValidationService(validator, new UrlPathHelper()), validationReportHandler);
    }

    public OpenApiValidationInterceptor(@Nonnull OpenApiValidationService openApiValidationService) {
        this(openApiValidationService, (ValidationReportHandler)new DefaultValidationReportHandler());
    }

    public OpenApiValidationInterceptor(@Nonnull OpenApiValidationService openApiValidationService, @Nonnull ValidationReportHandler validationReportHandler) {
        Objects.requireNonNull(openApiValidationService, "openApiValidationService must not be null");
        Objects.requireNonNull(validationReportHandler, "validationReportHandler must not be null");
        this.openApiValidationService = openApiValidationService;
        this.validationReportHandler = validationReportHandler;
    }

    private static boolean skipValidationStep(HttpServletRequest servletRequest, String attributeName) {
        return !Boolean.TRUE.equals(servletRequest.getAttribute(attributeName));
    }

    private static String buildRequestLoggingKey(HttpServletRequest servletRequest) {
        return servletRequest.getMethod() + "#" + servletRequest.getRequestURI();
    }

    private void validateRequest(HttpServletRequest servletRequest, Supplier<Body> bodySupplier) {
        String requestLoggingKey = OpenApiValidationInterceptor.buildRequestLoggingKey(servletRequest);
        LOG.debug("OpenAPI request validation: {}", (Object)requestLoggingKey);
        Request request = this.openApiValidationService.buildRequest(servletRequest, bodySupplier);
        ValidationReport validationReport = this.openApiValidationService.validateRequest(request);
        this.validationReportHandler.handleRequestReport(requestLoggingKey, validationReport);
    }

    private void validateResponse(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ContentCachingResponseWrapper cachedResponse) {
        String requestLoggingKey = OpenApiValidationInterceptor.buildRequestLoggingKey(servletRequest);
        LOG.debug("OpenAPI response validation: {}", (Object)requestLoggingKey);
        Response response = this.openApiValidationService.buildResponse(cachedResponse);
        ValidationReport validationReport = this.openApiValidationService.validateResponse(servletRequest, response);
        try {
            this.validationReportHandler.handleResponseReport(requestLoggingKey, validationReport);
        }
        catch (InvalidResponseException e) {
            cachedResponse.reset();
            Map alreadySetHeaders = (Map)servletRequest.getAttribute(ATTRIBUTE_ALREADY_SET_HEADERS);
            this.openApiValidationService.addHeadersToResponse(servletResponse, alreadySetHeaders);
            throw e;
        }
    }

    public boolean preHandle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler) throws Exception {
        if (!OpenApiValidationInterceptor.skipValidationStep(servletRequest, OpenApiValidationFilter.ATTRIBUTE_RESPONSE_VALIDATION)) {
            Map<String, List<String>> alreadySetHeaders = this.openApiValidationService.resolveHeadersOnResponse(servletResponse);
            servletRequest.setAttribute(ATTRIBUTE_ALREADY_SET_HEADERS, alreadySetHeaders);
        }
        if (OpenApiValidationInterceptor.skipValidationStep(servletRequest, OpenApiValidationFilter.ATTRIBUTE_REQUEST_VALIDATION)) {
            LOG.debug("OpenAPI request validation skipped for this request");
        } else if (servletRequest instanceof ResettableRequestServletWrapper) {
            ServletInputStream inputStream = servletRequest.getInputStream();
            Supplier<Body> bodySupplier = () -> OpenApiValidationInterceptor.lambda$preHandle$0((InputStream)inputStream);
            this.validateRequest(servletRequest, bodySupplier);
            ((ResettableRequestServletWrapper)servletRequest).resetInputStream();
        } else if (servletRequest instanceof ContentCachingRequestWrapper) {
            Supplier<Body> bodySupplier = () -> new ByteArrayBody(((ContentCachingRequestWrapper)servletRequest).getContentAsByteArray());
            this.validateRequest(servletRequest, bodySupplier);
        } else {
            LOG.debug("OpenAPI request validation skipped: unsupported HttpServletRequest type");
        }
        return true;
    }

    public void postHandle(HttpServletRequest servletRequest, HttpServletResponse servletResponse, Object handler, ModelAndView modelAndView) {
        if (OpenApiValidationInterceptor.skipValidationStep(servletRequest, OpenApiValidationFilter.ATTRIBUTE_RESPONSE_VALIDATION)) {
            LOG.debug("OpenAPI response validation skipped for this request");
        } else {
            OpenApiValidationContentCachingResponseWrapper cachedResponse = ResponseUtils.getCachingResponse(servletResponse);
            if (cachedResponse != null) {
                this.validateResponse(servletRequest, servletResponse, cachedResponse);
            } else {
                LOG.debug("OpenAPI response validation skipped: unsupported HttpServletResponse type");
            }
        }
    }

    private static /* synthetic */ Body lambda$preHandle$0(InputStream inputStream) {
        return new ResettableInputStreamBody((ResettableRequestServletWrapper.CachingServletInputStream)((Object)inputStream));
    }
}

