/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.springmvc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ResettableRequestServletWrapper
extends HttpServletRequestWrapper {
    private ServletInputStream servletInputStream;
    private BufferedReader reader;
    private Integer contentLength;

    ResettableRequestServletWrapper(HttpServletRequest request) {
        super(request);
    }

    public void resetInputStream() throws IOException {
        if (this.servletInputStream == null) {
            this.servletInputStream = CachedServletInputStream.empty();
            this.contentLength = -1;
        } else if (this.servletInputStream instanceof WrappedOriginalServletInputStream) {
            WrappedOriginalServletInputStream wrapped = (WrappedOriginalServletInputStream)this.servletInputStream;
            this.servletInputStream = new CachedServletInputStream(wrapped.cachedContent, wrapped.chunkSize, wrapped.count);
            this.contentLength = wrapped.count;
        } else if (this.servletInputStream instanceof CachedServletInputStream) {
            this.servletInputStream.reset();
        }
        this.reader = null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.servletInputStream == null) {
            this.servletInputStream = new WrappedOriginalServletInputStream(super.getInputStream());
        }
        return this.servletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            String encoding = super.getCharacterEncoding();
            InputStreamReader streamReader = encoding == null ? new InputStreamReader((InputStream)this.getInputStream()) : new InputStreamReader((InputStream)this.getInputStream(), encoding);
            this.reader = new BufferedReader(streamReader);
        }
        return this.reader;
    }

    public int getContentLength() {
        return this.contentLength != null ? this.contentLength.intValue() : super.getContentLength();
    }

    private static class CachedServletInputStream
    extends ServletInputStream {
        private final List<byte[]> cachedContent;
        private final int chunkSize;
        private final int count;
        private int pos = 0;

        private CachedServletInputStream(List<byte[]> cachedContent, int chunkSize, int count) {
            this.cachedContent = cachedContent;
            this.chunkSize = chunkSize;
            this.count = count;
        }

        private static CachedServletInputStream empty() {
            return new CachedServletInputStream(null, -1, -1);
        }

        public synchronized int read() {
            return this.pos < this.count ? this.cachedContent.get(this.pos / this.chunkSize)[this.pos++ % this.chunkSize] & 0xFF : -1;
        }

        public synchronized int read(byte[] b, int off, int len) {
            if (this.pos >= this.count) {
                return -1;
            }
            int avail = this.count - this.pos;
            if (len > avail) {
                len = avail;
            }
            if (len <= 0) {
                return 0;
            }
            int leftLen = len;
            int destPos = off;
            while (leftLen > 0) {
                int srcPos = this.pos % this.chunkSize;
                int length = Math.min(leftLen, this.chunkSize - srcPos);
                System.arraycopy(this.cachedContent.get(this.pos / this.chunkSize), srcPos, b, destPos, length);
                leftLen -= length;
                destPos += length;
                this.pos += length;
            }
            return len;
        }

        public boolean isFinished() {
            return this.pos >= this.count;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new IllegalStateException("Can't set ReadListener on CachedServletInputStream.");
        }

        public void reset() {
            this.pos = 0;
        }
    }

    private static class WrappedOriginalServletInputStream
    extends ServletInputStream {
        private final ServletInputStream originalServletInputStream;
        private final List<byte[]> cachedContent;
        private final int chunkSize;
        private int count = 0;

        private WrappedOriginalServletInputStream(ServletInputStream originalServletInputStream) {
            this.originalServletInputStream = originalServletInputStream;
            this.cachedContent = new ArrayList<byte[]>();
            this.chunkSize = 8192;
        }

        public boolean isFinished() {
            return this.originalServletInputStream.isFinished();
        }

        public boolean isReady() {
            return this.originalServletInputStream.isReady();
        }

        public void setReadListener(ReadListener readListener) {
            this.originalServletInputStream.setReadListener(readListener);
        }

        public synchronized int read() throws IOException {
            int value = this.originalServletInputStream.read();
            if (value != -1) {
                this.ensureCapacity();
                this.cachedContent.get((int)(this.cachedContent.size() - 1))[this.count++ % this.chunkSize] = (byte)value;
            }
            return value;
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int result = this.originalServletInputStream.read(b, off, len);
            if (result > 0) {
                int leftLen = result;
                int srcPos = off;
                while (leftLen > 0) {
                    this.ensureCapacity();
                    int destPos = this.count % this.chunkSize;
                    int length = Math.min(leftLen, this.chunkSize - destPos);
                    System.arraycopy(b, srcPos, this.cachedContent.get(this.cachedContent.size() - 1), destPos, length);
                    leftLen -= length;
                    srcPos += length;
                    this.count += length;
                }
            }
            return result;
        }

        private void ensureCapacity() {
            if (this.count % this.chunkSize == 0) {
                this.cachedContent.add(new byte[this.chunkSize]);
            }
        }
    }
}

