/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.wiremock;

import com.atlassian.oai.validator.wiremock.SwaggerValidationListener;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.junit.WireMockRule;

public class ValidatedWireMockRule
extends WireMockRule {
    private SwaggerValidationListener validationListener;

    public ValidatedWireMockRule(String swaggerJsonUrl, Options options) {
        super(options);
        this.setupValidationListener(swaggerJsonUrl);
    }

    public ValidatedWireMockRule(String swaggerJsonUrl, Options options, boolean failOnUnmatchedStubs) {
        super(options, failOnUnmatchedStubs);
        this.setupValidationListener(swaggerJsonUrl);
    }

    public ValidatedWireMockRule(String swaggerJsonUrl, int port) {
        super(port);
        this.setupValidationListener(swaggerJsonUrl);
    }

    public ValidatedWireMockRule(String swaggerJsonUrl, int port, Integer httpsPort) {
        super(port, httpsPort);
        this.setupValidationListener(swaggerJsonUrl);
    }

    public ValidatedWireMockRule(String swaggerJsonUrl) {
        this.setupValidationListener(swaggerJsonUrl);
    }

    private void setupValidationListener(String swaggerJsonUrl) {
        this.validationListener = new SwaggerValidationListener(swaggerJsonUrl);
        this.addMockServiceRequestListener(this.validationListener);
    }

    protected void before() {
        this.validationListener.reset();
    }

    protected void after() {
        try {
            this.validationListener.assertValidationPassed();
        }
        finally {
            this.stop();
        }
    }
}

