/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.wiremock;

import com.atlassian.oai.validator.model.Request;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.MultiValue;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class WireMockRequest
implements Request {
    private final com.github.tomakehurst.wiremock.http.Request internalRequest;
    private final String requestPath;
    private final Map<String, QueryParameter> queryParameterMap;

    public WireMockRequest(@Nonnull com.github.tomakehurst.wiremock.http.Request internalRequest) {
        this.internalRequest = Objects.requireNonNull(internalRequest, "A WireMock request is required.");
        URI uri = URI.create(internalRequest.getUrl());
        this.queryParameterMap = Urls.splitQuery((URI)uri);
        this.requestPath = uri.getPath();
    }

    @Nonnull
    public String getPath() {
        return this.requestPath;
    }

    @Nonnull
    public Request.Method getMethod() {
        return Request.Method.valueOf((String)this.internalRequest.getMethod().getName());
    }

    @Nonnull
    public Optional<String> getBody() {
        return Optional.ofNullable(this.internalRequest.getBodyAsString());
    }

    @Nonnull
    public Collection<String> getQueryParameters() {
        return this.queryParameterMap.keySet();
    }

    @Nonnull
    public Collection<String> getQueryParameterValues(String name) {
        if (this.queryParameterMap.containsKey(name)) {
            return this.queryParameterMap.get(name).values();
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Map<String, Collection<String>> getHeaders() {
        return this.internalRequest.getHeaders().all().stream().collect(Collectors.toMap(MultiValue::key, MultiValue::values));
    }

    @Nonnull
    public Collection<String> getHeaderValues(String name) {
        HttpHeader header = this.internalRequest.getHeaders().getHeader(name);
        if (header.isPresent()) {
            return header.values();
        }
        return Collections.emptyList();
    }
}

