/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.wiremock;

import com.atlassian.oai.validator.model.Response;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class WireMockResponse
implements Response {
    private final com.github.tomakehurst.wiremock.http.Response internalResponse;

    public WireMockResponse(@Nonnull com.github.tomakehurst.wiremock.http.Response internalResponse) {
        this.internalResponse = Objects.requireNonNull(internalResponse, "A WireMock response is required.");
    }

    public int getStatus() {
        return this.internalResponse.getStatus();
    }

    @Nonnull
    public Optional<String> getBody() {
        return Optional.ofNullable(this.internalResponse.getBodyAsString());
    }

    @Nonnull
    public Collection<String> getHeaderValues(String name) {
        HttpHeader header = this.internalResponse.getHeaders().getHeader(name);
        if (header.isPresent()) {
            return header.values();
        }
        return Collections.emptyList();
    }
}

