/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.wiremock;

import com.atlassian.oai.validator.SwaggerRequestResponseValidator;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.report.ValidationReportFormatter;
import com.atlassian.oai.validator.wiremock.WireMockRequest;
import com.atlassian.oai.validator.wiremock.WireMockResponse;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerValidationListener
implements RequestListener {
    private static final Logger log = LoggerFactory.getLogger(SwaggerValidationListener.class);
    private final SwaggerRequestResponseValidator validator;
    private ValidationReport report = ValidationReport.empty();

    public SwaggerValidationListener(String swaggerJsonUrl) {
        this.validator = SwaggerRequestResponseValidator.createFor((String)swaggerJsonUrl).build();
    }

    public void requestReceived(Request request, Response response) {
        try {
            this.report = this.report.merge(this.validator.validate(WireMockRequest.of(request), WireMockResponse.of(response)));
        }
        catch (Exception e) {
            log.error("Exception occurred while validating request", (Throwable)e);
            throw e;
        }
    }

    public ValidationReport getReport() {
        return this.report;
    }

    public void reset() {
        this.report = ValidationReport.empty();
    }

    public void assertValidationPassed() {
        if (this.report.hasErrors()) {
            throw new SwaggerValidationException(this.report);
        }
    }

    public static class SwaggerValidationException
    extends RuntimeException {
        public SwaggerValidationException(ValidationReport report) {
            super(ValidationReportFormatter.format((ValidationReport)report));
        }
    }
}

