/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.wiremock;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.report.JsonValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.wiremock.WireMockRequest;
import com.atlassian.oai.validator.wiremock.WireMockResponse;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiValidationListener
implements RequestListener {
    private static final Logger log = LoggerFactory.getLogger(OpenApiValidationListener.class);
    private final OpenApiInteractionValidator validator;
    private ValidationReport report = ValidationReport.empty();

    public OpenApiValidationListener(String specUrlOrDefinition) {
        this.validator = OpenApiInteractionValidator.createFor((String)specUrlOrDefinition).build();
    }

    public OpenApiValidationListener(OpenApiInteractionValidator validator) {
        this.validator = Objects.requireNonNull(validator, "A configured validator is required");
    }

    public void requestReceived(Request request, Response response) {
        try {
            this.report = this.report.merge(this.validator.validate(WireMockRequest.of(request), WireMockResponse.of(response)));
        }
        catch (Exception e) {
            log.error("Exception occurred while validating request", (Throwable)e);
            throw e;
        }
    }

    public ValidationReport getReport() {
        return this.report;
    }

    public void reset() {
        this.report = ValidationReport.empty();
    }

    public void assertValidationPassed() {
        if (this.report.hasErrors()) {
            throw new OpenApiValidationException(this.report);
        }
    }

    public static class OpenApiValidationException
    extends RuntimeException {
        private final ValidationReport report;

        public OpenApiValidationException(ValidationReport report) {
            super(JsonValidationReportFormat.getInstance().apply(report));
            this.report = report;
        }

        public ValidationReport getValidationReport() {
            return this.report;
        }
    }
}

