/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.wiremock;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.wiremock.OpenApiValidationListener;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.junit.WireMockRule;

public class ValidatedWireMockRule
extends WireMockRule {
    private OpenApiValidationListener validationListener;

    public ValidatedWireMockRule(String specUrlOrPayload, Options options) {
        super(options);
        this.setupValidationListener(specUrlOrPayload);
    }

    public ValidatedWireMockRule(OpenApiInteractionValidator validator, Options options) {
        super(options);
        this.setupValidationListener(validator);
    }

    public ValidatedWireMockRule(String specUrlOrPayload, Options options, boolean failOnUnmatchedStubs) {
        super(options, failOnUnmatchedStubs);
        this.setupValidationListener(specUrlOrPayload);
    }

    public ValidatedWireMockRule(OpenApiInteractionValidator validator, Options options, boolean failOnUnmatchedStubs) {
        super(options, failOnUnmatchedStubs);
        this.setupValidationListener(validator);
    }

    public ValidatedWireMockRule(String specUrlOrPayload, int port) {
        super(port);
        this.setupValidationListener(specUrlOrPayload);
    }

    public ValidatedWireMockRule(OpenApiInteractionValidator validator, int port) {
        super(port);
        this.setupValidationListener(validator);
    }

    public ValidatedWireMockRule(String specUrlOrPayload, int port, Integer httpsPort) {
        super(port, httpsPort);
        this.setupValidationListener(specUrlOrPayload);
    }

    public ValidatedWireMockRule(OpenApiInteractionValidator validator, int port, Integer httpsPort) {
        super(port, httpsPort);
        this.setupValidationListener(validator);
    }

    public ValidatedWireMockRule(String specUrlOrPayload) {
        this.setupValidationListener(specUrlOrPayload);
    }

    public ValidatedWireMockRule(OpenApiInteractionValidator validator) {
        this.setupValidationListener(validator);
    }

    private void setupValidationListener(String specUrlOrPayload) {
        this.validationListener = new OpenApiValidationListener(specUrlOrPayload);
        this.addMockServiceRequestListener(this.validationListener);
    }

    private void setupValidationListener(OpenApiInteractionValidator validator) {
        this.validationListener = new OpenApiValidationListener(validator);
        this.addMockServiceRequestListener(this.validationListener);
    }

    protected void before() {
        this.validationListener.reset();
    }

    protected void after() {
        try {
            this.validationListener.assertValidationPassed();
        }
        finally {
            this.stop();
        }
    }
}

