/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator;

import com.atlassian.ta.wiremockpactgenerator.WireMockPactGeneratorUserOptions;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRegistry;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorResponse;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WireMockPactGenerator
implements RequestListener {
    private final WireMockPactGeneratorUserOptions userOptions;

    public static Builder builder(String consumerName, String providerName) {
        return new Builder(consumerName, providerName);
    }

    private WireMockPactGenerator(WireMockPactGeneratorUserOptions userOptions) {
        this.userOptions = userOptions;
    }

    public void requestReceived(Request request, Response response) {
        try {
            this.processInteraction(request, response);
        }
        catch (RuntimeException exception) {
            System.err.println("WireMock Pact Generator: unexpected error. Forcing system exit.");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public String getPactLocation() {
        return PactGeneratorRegistry.getPactLocation(this.userOptions);
    }

    private void processInteraction(Request request, Response response) {
        PactGeneratorRequest.Builder requestBuilder = new PactGeneratorRequest.Builder().withMethod(request.getMethod().value()).withUrl(request.getUrl()).withHeaders(this.extractHeaders(request.getHeaders())).withBody(request.getBodyAsString());
        PactGeneratorResponse.Builder responseBuilder = new PactGeneratorResponse.Builder().withStatus(response.getStatus()).withHeaders(this.extractHeaders(response.getHeaders())).withBody(response.getBody() == null ? "" : response.getBodyAsString()).withIsConfiguredResponse(response.wasConfigured());
        PactGeneratorRegistry.processInteraction(this.userOptions, requestBuilder.build(), responseBuilder.build());
    }

    private Map<String, List<String>> extractHeaders(HttpHeaders wireMockHeaders) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (HttpHeader header : wireMockHeaders.all()) {
            headers.put(header.key(), header.values());
        }
        return headers;
    }

    public static class Builder {
        private final List<String> requestPathWhitelist;
        private final List<String> requestPathBlacklist;
        private final String consumerName;
        private final String providerName;

        private Builder(String consumerName, String providerName) {
            this(consumerName, providerName, Collections.emptyList(), Collections.emptyList());
        }

        private Builder(String consumerName, String providerName, List<String> requestPathWhitelist, List<String> requestPathBlacklist) {
            this.consumerName = consumerName;
            this.providerName = providerName;
            this.requestPathWhitelist = requestPathWhitelist;
            this.requestPathBlacklist = requestPathBlacklist;
        }

        public Builder withRequestPathWhitelist(String ... regexPatterns) {
            List<String> newRequestPathWhitelist = this.extendListWithItems(this.requestPathWhitelist, regexPatterns);
            return new Builder(this.consumerName, this.providerName, newRequestPathWhitelist, this.requestPathBlacklist);
        }

        public Builder withRequestPathBlacklist(String ... regexPatterns) {
            List<String> newRequestPathBlacklist = this.extendListWithItems(this.requestPathBlacklist, regexPatterns);
            return new Builder(this.consumerName, this.providerName, this.requestPathWhitelist, newRequestPathBlacklist);
        }

        public WireMockPactGenerator build() {
            WireMockPactGeneratorUserOptions userOptions = new WireMockPactGeneratorUserOptions(this.consumerName, this.providerName, this.requestPathWhitelist, this.requestPathBlacklist);
            return new WireMockPactGenerator(userOptions);
        }

        private <T> List<T> extendListWithItems(List<T> original, T[] items) {
            ArrayList<T> copyOfOriginal = new ArrayList<T>(original);
            copyOfOriginal.addAll(Arrays.asList(items));
            return copyOfOriginal;
        }
    }
}

