/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator;

import com.atlassian.ta.wiremockpactgenerator.pactgenerator.InteractionFilter;
import com.atlassian.ta.wiremockpactgenerator.support.Validation;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class WireMockPactGeneratorUserOptions {
    private final String consumerName;
    private final String providerName;
    private final List<Pattern> requestPathWhitelist;
    private final List<Pattern> requestPathBlacklist;

    public WireMockPactGeneratorUserOptions(String consumerName, String providerName, List<String> requestPathWhitelist, List<String> requestPathBlacklist) {
        this.consumerName = Validation.notNullNorBlank(consumerName, "consumer name");
        this.providerName = Validation.notNullNorBlank(providerName, "provider name");
        this.requestPathWhitelist = this.loadPatternListOption(requestPathWhitelist, "Invalid regex pattern in request path whitelist");
        this.requestPathBlacklist = this.loadPatternListOption(requestPathBlacklist, "Invalid regex pattern in request path blacklist");
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public InteractionFilter getInteractionFilter() {
        return new InteractionFilter(this.requestPathWhitelist, this.requestPathBlacklist);
    }

    private List<Pattern> loadPatternListOption(List<String> patternList, String errorMessage) {
        return Validation.withWireMockPactGeneratorExceptionWrapper(() -> patternList.stream().map(Pattern::compile).collect(Collectors.toList()), errorMessage);
    }
}

