/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import com.atlassian.ta.wiremockpactgenerator.WireMockPactGeneratorUserOptions;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.FileSystem;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.IdGenerator;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.LocalFileSystem;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGenerator;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorInteraction;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorResponse;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.UuidGenerator;
import java.util.HashMap;
import java.util.Map;

public final class PactGeneratorRegistry {
    private static final Map<String, PactGenerator> instances = new HashMap<String, PactGenerator>();
    private static final FileSystem fileSystem = new LocalFileSystem();
    private static final IdGenerator idGenerator = new UuidGenerator();

    private PactGeneratorRegistry() {
    }

    public static synchronized void processInteraction(WireMockPactGeneratorUserOptions userOptions, PactGeneratorRequest request, PactGeneratorResponse response) {
        PactGeneratorInteraction interaction = new PactGeneratorInteraction(request, response, userOptions.getInteractionFilter());
        PactGeneratorRegistry.getInstance(userOptions).process(interaction);
    }

    public static synchronized String getPactLocation(WireMockPactGeneratorUserOptions userOptions) {
        return PactGeneratorRegistry.getInstance(userOptions).getPactLocation();
    }

    private static PactGenerator getInstance(WireMockPactGeneratorUserOptions userOptions) {
        String consumerName = userOptions.getConsumerName();
        String providerName = userOptions.getProviderName();
        String key = String.format("consumer-%s-provider-%s", consumerName, providerName);
        if (!instances.containsKey(key)) {
            instances.put(key, new PactGenerator(consumerName, providerName, fileSystem, idGenerator));
        }
        return instances.get(key);
    }
}

