/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import com.atlassian.ta.wiremockpactgenerator.pactgenerator.Headers;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class PactGeneratorRequest {
    private final String method;
    private final String url;
    private final String body;
    private final Map<String, List<String>> headers;

    private PactGeneratorRequest(String method, String url, Map<String, List<String>> headers, String body) {
        this.method = method;
        this.url = url;
        this.body = body;
        this.headers = headers;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        try {
            return new URL("http", "dummyhost", this.getUrl()).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getQuery() {
        try {
            return new URL("http", "dummyhost", this.getUrl()).getQuery();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        private final String method;
        private final String url;
        private final String body;
        private final Map<String, List<String>> headers;

        public Builder() {
            this(null, null, null, null);
        }

        private Builder(String method, String url, String body, Map<String, List<String>> headers) {
            this.method = method;
            this.url = url;
            this.body = body;
            this.headers = Headers.cloneHeaders(headers);
        }

        public Builder withMethod(String method) {
            return new Builder(method, this.url, this.body, this.headers);
        }

        public Builder withUrl(String url) {
            return new Builder(this.method, url, this.body, this.headers);
        }

        public Builder withHeaders(Map<String, List<String>> headers) {
            return new Builder(this.method, this.url, this.body, headers);
        }

        public Builder withBody(String body) {
            return new Builder(this.method, this.url, body, this.headers);
        }

        public PactGeneratorRequest build() {
            return new PactGeneratorRequest(this.method, this.url, this.headers, this.body);
        }
    }
}

