/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import com.atlassian.ta.wiremockpactgenerator.pactgenerator.Headers;
import java.util.List;
import java.util.Map;

public class PactGeneratorResponse {
    private final int status;
    private final String body;
    private final Map<String, List<String>> headers;
    private final boolean isConfiguredResponse;

    private PactGeneratorResponse(int status, Map<String, List<String>> headers, String body, boolean isConfiguredResponse) {
        this.status = status;
        this.headers = headers;
        this.body = body;
        this.isConfiguredResponse = isConfiguredResponse;
    }

    public int getStatus() {
        return this.status;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public boolean isConfigured() {
        return this.isConfiguredResponse;
    }

    public static class Builder {
        private final int status;
        private final String body;
        private final Map<String, List<String>> headers;
        private final boolean isConfiguredResponse;

        public Builder() {
            this(0, null, null, false);
        }

        private Builder(int status, String body, Map<String, List<String>> headers, boolean isConfiguredResponse) {
            this.status = status;
            this.body = body;
            this.headers = Headers.cloneHeaders(headers);
            this.isConfiguredResponse = isConfiguredResponse;
        }

        public Builder withStatus(int status) {
            return new Builder(status, this.body, this.headers, this.isConfiguredResponse);
        }

        public Builder withBody(String body) {
            return new Builder(this.status, body, this.headers, this.isConfiguredResponse);
        }

        public Builder withHeaders(Map<String, List<String>> headers) {
            return new Builder(this.status, this.body, headers, this.isConfiguredResponse);
        }

        public Builder withIsConfiguredResponse(boolean isConfiguredResponse) {
            return new Builder(this.status, this.body, this.headers, isConfiguredResponse);
        }

        public PactGeneratorResponse build() {
            return new PactGeneratorResponse(this.status, this.headers, this.body, this.isConfiguredResponse);
        }
    }
}

