/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorResponse;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.models.PactInteraction;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.models.PactRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.models.PactResponse;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class PactGeneratorToPactInteractionTransformer {
    private static final List<String> IGNORE_REQUEST_HEADERS = Collections.singletonList("host");
    private static final List<String> IGNORE_RESPONSE_HEADERS = Collections.emptyList();

    private PactGeneratorToPactInteractionTransformer() {
    }

    public static PactInteraction transform(PactGeneratorRequest request, PactGeneratorResponse response) {
        PactRequest pactRequest = PactGeneratorToPactInteractionTransformer.toPactRequest(request);
        PactResponse pactResponse = PactGeneratorToPactInteractionTransformer.toPactResponse(response);
        String description = PactGeneratorToPactInteractionTransformer.getDescription(pactRequest, pactResponse);
        return new PactInteraction(description, pactRequest, pactResponse);
    }

    private static PactRequest toPactRequest(PactGeneratorRequest request) {
        return new PactRequest(request.getMethod().toUpperCase(), request.getPath(), request.getQuery(), PactGeneratorToPactInteractionTransformer.getProcessedHeaders(request.getHeaders(), IGNORE_REQUEST_HEADERS), PactGeneratorToPactInteractionTransformer.normalizeBody(request.getBody()));
    }

    private static PactResponse toPactResponse(PactGeneratorResponse response) {
        return new PactResponse(response.getStatus(), PactGeneratorToPactInteractionTransformer.getProcessedHeaders(response.getHeaders(), IGNORE_RESPONSE_HEADERS), PactGeneratorToPactInteractionTransformer.normalizeBody(response.getBody()), response.isConfigured());
    }

    private static Map<String, String> getProcessedHeaders(Map<String, List<String>> rawHeaders, List<String> ignoreHeaders) {
        if (rawHeaders == null) {
            return new HashMap<String, String>();
        }
        return rawHeaders.entrySet().stream().map(header -> new AbstractMap.SimpleEntry<String, String>(((String)header.getKey()).toLowerCase(Locale.ENGLISH), String.join((CharSequence)", ", (Iterable)header.getValue()))).filter(header -> !ignoreHeaders.contains(header.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static String normalizeBody(String body) {
        return body == null || body.isEmpty() ? null : body;
    }

    private static String getDescription(PactRequest pactRequest, PactResponse pactResponse) {
        String notConfiguredWarningOrEmpty = pactResponse.isConfigured() ? "" : " [Not configured in WireMock]";
        return String.format("%s %s -> %s%s", pactRequest.getMethod(), pactRequest.getPath(), pactResponse.getStatus(), notConfiguredWarningOrEmpty);
    }
}

