/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import com.atlassian.ta.wiremockpactgenerator.WireMockPactGeneratorException;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.FileSystem;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.IdGenerator;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.json.GsonInstance;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.models.Pact;
import com.google.gson.Gson;
import java.text.Normalizer;
import java.util.regex.Pattern;

class PactSaver {
    private static final Pattern NON_ALPHANUMERIC = Pattern.compile("[^\\w-]");
    private final Gson gson = GsonInstance.gson;
    private final FileSystem fileSystem;
    private final String uuid;

    PactSaver(FileSystem fileSystem, IdGenerator idGenerator) {
        this.fileSystem = fileSystem;
        this.uuid = idGenerator.generate();
    }

    String getPactFileLocation(Pact pact) {
        return String.format("%s/%s", this.getPactsPath(), this.getPactFileName(pact, this.uuid));
    }

    void savePactFile(Pact pact) {
        String pactPath = this.getPactsPath();
        this.ensurePathExists(pactPath);
        String pactFileLocation = this.getPactFileLocation(pact);
        String pactJson = this.gson.toJson((Object)pact);
        this.saveFile(pactFileLocation, pactJson);
    }

    private void saveFile(String pactFileLocation, String pactJson) {
        try {
            this.fileSystem.saveFile(pactFileLocation, pactJson);
        }
        catch (Exception e) {
            throw new WireMockPactGeneratorException(String.format("Unable to save file '%s'", pactFileLocation), e);
        }
    }

    private void ensurePathExists(String pactPath) {
        if (!this.fileSystem.pathExists(pactPath)) {
            this.fileSystem.createPath(pactPath);
        }
    }

    private String getPactsPath() {
        return String.format("%s/pacts", this.getOutputPath());
    }

    private String getOutputPath() {
        if (!this.fileSystem.pathExists("target") && this.fileSystem.pathExists("build")) {
            return "build";
        }
        return "target";
    }

    private String getPactFileName(Pact pact, String guid) {
        String sanitizedConsumer = this.sanitize(pact.getConsumer().getName());
        String sanitizedProvider = this.sanitize(pact.getProvider().getName());
        return String.format("%s-%s-%s-pact.json", sanitizedConsumer, sanitizedProvider, guid);
    }

    private String sanitize(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        return NON_ALPHANUMERIC.matcher(s).replaceAll("");
    }
}

