/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator;

import com.atlassian.ta.wiremockpactgenerator.WireMockPactGeneratorUserOptions;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRegistry;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorResponse;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class WireMockPactGenerator
implements RequestListener {
    private final WireMockPactGeneratorUserOptions userOptions;
    private final Consumer<RuntimeException> unexpectedErrorHandler;

    public static Builder builder(String consumerName, String providerName) {
        return new Builder(consumerName, providerName);
    }

    private WireMockPactGenerator(WireMockPactGeneratorUserOptions userOptions, Consumer<RuntimeException> unexpectedErrorHandler) {
        this.userOptions = userOptions;
        this.unexpectedErrorHandler = unexpectedErrorHandler;
    }

    public void requestReceived(Request request, Response response) {
        try {
            this.processInteraction(request, response);
        }
        catch (RuntimeException exception) {
            this.unexpectedErrorHandler.accept(exception);
        }
    }

    public String getPactLocation() {
        return PactGeneratorRegistry.getPactLocation(this.userOptions);
    }

    private void processInteraction(Request request, Response response) {
        PactGeneratorRequest.Builder requestBuilder = new PactGeneratorRequest.Builder().withMethod(request.getMethod().value()).withUrl(request.getUrl()).withHeaders(this.extractHeaders(request.getHeaders())).withBody(request.getBodyAsString());
        PactGeneratorResponse.Builder responseBuilder = new PactGeneratorResponse.Builder().withStatus(response.getStatus()).withHeaders(this.extractHeaders(response.getHeaders())).withBody(response.getBody() == null ? "" : response.getBodyAsString()).withIsConfiguredResponse(response.wasConfigured());
        PactGeneratorRegistry.processInteraction(this.userOptions, requestBuilder.build(), responseBuilder.build());
    }

    private Map<String, List<String>> extractHeaders(HttpHeaders wireMockHeaders) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        for (HttpHeader header : wireMockHeaders.all()) {
            headers.put(header.key(), header.values());
        }
        return headers;
    }

    public static class Builder {
        private static final Consumer<RuntimeException> defaultUnexpectedErrorHandler = e -> {
            System.err.println("WireMock Pact Generator: unexpected error. Forcing system exit.");
            e.printStackTrace();
            System.exit(1);
        };
        private final List<String> requestPathIncludeList;
        private final List<String> requestPathExcludeList;
        private final String consumerName;
        private final String providerName;
        private final boolean strictApplicationJson;
        private final List<String> requestHeaderIncludeList;
        private final List<String> responseHeaderIncludeList;
        private final Consumer<RuntimeException> unexpectedErrorHandler;
        private final boolean includeNotConfiguredResponses;

        private Builder(String consumerName, String providerName) {
            this(consumerName, providerName, Collections.emptyList(), Collections.emptyList(), true, Collections.emptyList(), Collections.emptyList(), defaultUnexpectedErrorHandler, true);
        }

        private Builder(String consumerName, String providerName, List<String> requestPathIncludeList, List<String> requestPathExcludeList, boolean strictApplicationJson, List<String> requestHeaderIncludeList, List<String> responseHeaderIncludeList, Consumer<RuntimeException> unexpectedErrorHandler, boolean includeNotConfiguredResponses) {
            this.consumerName = consumerName;
            this.providerName = providerName;
            this.requestPathIncludeList = requestPathIncludeList;
            this.requestPathExcludeList = requestPathExcludeList;
            this.strictApplicationJson = strictApplicationJson;
            this.requestHeaderIncludeList = requestHeaderIncludeList;
            this.responseHeaderIncludeList = responseHeaderIncludeList;
            this.unexpectedErrorHandler = unexpectedErrorHandler;
            this.includeNotConfiguredResponses = includeNotConfiguredResponses;
        }

        public Builder withRequestPathIncludeList(String ... regexPatterns) {
            List<String> newRequestPathIncludeList = this.extendListWithItems(this.requestPathIncludeList, regexPatterns);
            return new Builder(this.consumerName, this.providerName, newRequestPathIncludeList, this.requestPathExcludeList, this.strictApplicationJson, this.requestHeaderIncludeList, this.responseHeaderIncludeList, this.unexpectedErrorHandler, this.includeNotConfiguredResponses);
        }

        public Builder withRequestPathExcludeList(String ... regexPatterns) {
            List<String> newRequestPathExcludeList = this.extendListWithItems(this.requestPathExcludeList, regexPatterns);
            return new Builder(this.consumerName, this.providerName, this.requestPathIncludeList, newRequestPathExcludeList, this.strictApplicationJson, this.requestHeaderIncludeList, this.responseHeaderIncludeList, this.unexpectedErrorHandler, this.includeNotConfiguredResponses);
        }

        public Builder withStrictApplicationJson(boolean strictApplicationJson) {
            return new Builder(this.consumerName, this.providerName, this.requestPathIncludeList, this.requestPathExcludeList, strictApplicationJson, this.requestHeaderIncludeList, this.responseHeaderIncludeList, this.unexpectedErrorHandler, this.includeNotConfiguredResponses);
        }

        public Builder withRequestHeaderIncludeList(String ... httpHeaders) {
            List<String> newRequestHeaderIncludeList = this.extendListWithItems(this.requestHeaderIncludeList, httpHeaders);
            return new Builder(this.consumerName, this.providerName, this.requestPathIncludeList, this.requestPathExcludeList, this.strictApplicationJson, newRequestHeaderIncludeList, this.responseHeaderIncludeList, this.unexpectedErrorHandler, this.includeNotConfiguredResponses);
        }

        public Builder withResponseHeaderIncludeList(String ... httpHeaders) {
            List<String> newResponseHeaderIncludeList = this.extendListWithItems(this.responseHeaderIncludeList, httpHeaders);
            return new Builder(this.consumerName, this.providerName, this.requestPathIncludeList, this.requestPathExcludeList, this.strictApplicationJson, this.requestHeaderIncludeList, newResponseHeaderIncludeList, this.unexpectedErrorHandler, this.includeNotConfiguredResponses);
        }

        public Builder withUnexpectedErrorHandler(Consumer<RuntimeException> unexpectedErrorHandler) {
            return new Builder(this.consumerName, this.providerName, this.requestPathIncludeList, this.requestPathExcludeList, this.strictApplicationJson, this.requestHeaderIncludeList, this.responseHeaderIncludeList, unexpectedErrorHandler, this.includeNotConfiguredResponses);
        }

        public WireMockPactGenerator build() {
            WireMockPactGeneratorUserOptions userOptions = new WireMockPactGeneratorUserOptions(this.consumerName, this.providerName, this.requestPathIncludeList, this.requestPathExcludeList, this.strictApplicationJson, this.requestHeaderIncludeList, this.responseHeaderIncludeList, this.includeNotConfiguredResponses);
            return new WireMockPactGenerator(userOptions, this.unexpectedErrorHandler);
        }

        public Builder withIncludeNotConfiguredResponses(boolean includeNotConfiguredResponses) {
            return new Builder(this.consumerName, this.providerName, this.requestPathIncludeList, this.requestPathExcludeList, this.strictApplicationJson, this.requestHeaderIncludeList, this.responseHeaderIncludeList, this.unexpectedErrorHandler, includeNotConfiguredResponses);
        }

        @Deprecated
        public Builder withRequestPathWhitelist(String ... regexPatterns) {
            return this.withRequestPathIncludeList(regexPatterns);
        }

        @Deprecated
        public Builder withRequestPathBlacklist(String ... regexPatterns) {
            return this.withRequestPathExcludeList(regexPatterns);
        }

        @Deprecated
        public Builder withRequestHeaderWhitelist(String ... httpHeaders) {
            return this.withRequestHeaderIncludeList(httpHeaders);
        }

        @Deprecated
        public Builder withResponseHeaderWhitelist(String ... httpHeaders) {
            return this.withResponseHeaderIncludeList(httpHeaders);
        }

        private <T> List<T> extendListWithItems(List<T> original, T[] items) {
            ArrayList<T> copyOfOriginal = new ArrayList<T>(original);
            copyOfOriginal.addAll(Arrays.asList(items));
            return copyOfOriginal;
        }
    }
}

