/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ContentFilter {
    private static final String WIREMOCK_MATCHED_STUB_ID_HEADER = "matched-stub-id";
    private static final String WIREMOCK_MATCHED_STUB_NAME_HEADER = "matched-stub-name";
    private static final List<String> IGNORE_REQUEST_HEADERS = Collections.singletonList("host");
    private static final List<String> IGNORE_RESPONSE_HEADERS = Arrays.asList("matched-stub-id", "matched-stub-name");
    private final List<String> requestHeaderIncludeList;
    private final List<String> responseHeaderIncludeList;

    public ContentFilter(List<String> requestHeaderIncludeList, List<String> responseHeaderIncludeList) {
        this.requestHeaderIncludeList = requestHeaderIncludeList;
        this.responseHeaderIncludeList = responseHeaderIncludeList;
    }

    public boolean isRequestHeaderInIncludeList(String headerName) {
        if (this.requestHeaderIncludeList.isEmpty()) {
            return !IGNORE_REQUEST_HEADERS.contains(headerName);
        }
        return ContentFilter.headerMatchesAnyCaseInsensitiveKeys(headerName, this.requestHeaderIncludeList);
    }

    public boolean isResponseHeaderInIncludeList(String headerName) {
        if (this.responseHeaderIncludeList.isEmpty()) {
            return !IGNORE_RESPONSE_HEADERS.contains(headerName);
        }
        return ContentFilter.headerMatchesAnyCaseInsensitiveKeys(headerName, this.responseHeaderIncludeList);
    }

    private static boolean headerMatchesAnyCaseInsensitiveKeys(String headerName, List<String> headerIncludeList) {
        return headerIncludeList.stream().anyMatch(key -> key.equalsIgnoreCase(headerName));
    }
}

