/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorResponse;
import java.util.List;
import java.util.regex.Pattern;

public class InteractionFilter {
    private final List<Pattern> requestPathIncludeList;
    private final List<Pattern> requestPathExcludeList;
    private final boolean includeNotConfiguredResponses;

    public InteractionFilter(List<Pattern> requestPathIncludeList, List<Pattern> requestPathExcludeList, boolean includeNotConfiguredResponses) {
        this.requestPathIncludeList = requestPathIncludeList;
        this.requestPathExcludeList = requestPathExcludeList;
        this.includeNotConfiguredResponses = includeNotConfiguredResponses;
    }

    public boolean isInteractionAccepted(PactGeneratorRequest request, PactGeneratorResponse response) {
        return this.isAcceptedByPathIncludeList(request) && this.isAcceptedByPathExcludeList(request) && this.isResponseConfiguredOrIncludesNotConfiguredResponses(response);
    }

    private boolean isAcceptedByPathIncludeList(PactGeneratorRequest request) {
        return this.requestPathIncludeList.isEmpty() || InteractionFilter.pathMatchesAnyPattern(request.getPath(), this.requestPathIncludeList);
    }

    private boolean isAcceptedByPathExcludeList(PactGeneratorRequest request) {
        return !InteractionFilter.pathMatchesAnyPattern(request.getPath(), this.requestPathExcludeList);
    }

    private boolean isResponseConfiguredOrIncludesNotConfiguredResponses(PactGeneratorResponse response) {
        return this.includeNotConfiguredResponses || response.isConfigured();
    }

    private static boolean pathMatchesAnyPattern(String path, List<Pattern> patternList) {
        return patternList.stream().anyMatch(pattern -> pattern.matcher(path).matches());
    }
}

