/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.pactgenerator;

import com.atlassian.ta.wiremockpactgenerator.pactgenerator.ContentFilter;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.PactGeneratorResponse;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.models.PactInteraction;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.models.PactRequest;
import com.atlassian.ta.wiremockpactgenerator.pactgenerator.models.PactResponse;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class PactGeneratorToPactInteractionTransformer {
    private PactGeneratorToPactInteractionTransformer() {
    }

    public static PactInteraction transform(PactGeneratorRequest request, PactGeneratorResponse response, ContentFilter contentFilter) {
        PactRequest pactRequest = PactGeneratorToPactInteractionTransformer.toPactRequest(request, contentFilter);
        PactResponse pactResponse = PactGeneratorToPactInteractionTransformer.toPactResponse(response, contentFilter);
        String description = PactGeneratorToPactInteractionTransformer.getDescription(pactRequest, pactResponse);
        return new PactInteraction(description, pactRequest, pactResponse);
    }

    private static PactRequest toPactRequest(PactGeneratorRequest request, ContentFilter contentFilter) {
        return new PactRequest(request.getMethod().toUpperCase(), request.getPath(), request.getQuery(), PactGeneratorToPactInteractionTransformer.getProcessedHeaders(request.getHeaders(), header -> contentFilter.isRequestHeaderInIncludeList((String)header.getKey())), PactGeneratorToPactInteractionTransformer.normalizeBody(request.getBody()));
    }

    private static PactResponse toPactResponse(PactGeneratorResponse response, ContentFilter contentFilter) {
        return new PactResponse(response.getStatus(), PactGeneratorToPactInteractionTransformer.getProcessedHeaders(response.getHeaders(), header -> contentFilter.isResponseHeaderInIncludeList((String)header.getKey())), PactGeneratorToPactInteractionTransformer.normalizeBody(response.getBody()), response.isConfigured());
    }

    private static Map<String, String> getProcessedHeaders(Map<String, List<String>> rawHeaders, Predicate<AbstractMap.SimpleEntry<String, String>> headerFilter) {
        if (rawHeaders == null) {
            return new HashMap<String, String>();
        }
        return rawHeaders.entrySet().stream().map(header -> new AbstractMap.SimpleEntry<String, String>(((String)header.getKey()).toLowerCase(Locale.ENGLISH), String.join((CharSequence)", ", (Iterable)header.getValue()))).filter(headerFilter).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static String normalizeBody(String body) {
        return body == null || body.isEmpty() ? null : body;
    }

    private static String getDescription(PactRequest pactRequest, PactResponse pactResponse) {
        String notConfiguredWarningOrEmpty = pactResponse.isConfigured() ? "" : " [Not configured in WireMock]";
        return String.format("%s %s -> %s%s", pactRequest.getMethod(), pactRequest.getPath(), pactResponse.getStatus(), notConfiguredWarningOrEmpty);
    }
}

