/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ta.wiremockpactgenerator.support;

import com.atlassian.ta.wiremockpactgenerator.WireMockPactGeneratorException;

public class Validation {
    private Validation() {
    }

    public static <T> T withWireMockPactGeneratorExceptionWrapper(Work<T> work, String errorMessage) {
        try {
            return work.doWork();
        }
        catch (RuntimeException reason) {
            throw new WireMockPactGeneratorException(errorMessage, reason);
        }
    }

    public static String notNullNorBlank(String value, String description) {
        if (value == null || value.trim().length() == 0) {
            throw new WireMockPactGeneratorException(String.format("%s can't be null nor blank", description));
        }
        return value;
    }

    public static interface Work<T> {
        public T doWork();
    }
}

