/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.mapper;

import com.atomgraph.client.MediaTypes;
import com.atomgraph.client.vocabulary.HTTP;
import com.atomgraph.core.model.impl.Response;
import com.atomgraph.core.util.ModelUtils;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.DCTerms;
import org.apache.jena.vocabulary.RDF;

@Provider
public abstract class ExceptionMapperBase {
    @Context
    private Request request;
    @Context
    private Providers providers;
    @Inject
    MediaTypes mediaTypes;

    public Resource toResource(Exception ex, Response.Status status, Resource statusResource) {
        if (ex == null) {
            throw new IllegalArgumentException("Exception cannot be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("Response.Status cannot be null");
        }
        Resource resource = ModelFactory.createDefaultModel().createResource().addProperty(RDF.type, (RDFNode)HTTP.Response).addLiteral((Property)HTTP.statusCodeValue, (long)status.getStatusCode()).addLiteral((Property)HTTP.reasonPhrase, (Object)status.getReasonPhrase());
        if (statusResource != null) {
            resource.addProperty((Property)HTTP.sc, (RDFNode)statusResource);
        }
        if (ex.getMessage() != null) {
            resource.addLiteral(DCTerms.title, (Object)ex.getMessage());
        }
        return resource;
    }

    public Response.ResponseBuilder getResponseBuilder(Model model) {
        return new Response(this.getRequest(), (Object)model, null, new EntityTag(Long.toHexString(ModelUtils.hashModel((Model)model))), this.getVariants(Model.class)).getResponseBuilder();
    }

    public List<Variant> getVariants(Class clazz) {
        return this.getVariants(this.getWritableMediaTypes(clazz));
    }

    public List<Variant> getVariants(List<MediaType> mediaTypes) {
        return Response.getVariantListBuilder(mediaTypes, this.getLanguages(), this.getEncodings()).add().build();
    }

    public List<MediaType> getWritableMediaTypes(Class clazz) {
        return this.getMediaTypes().getWritable(clazz);
    }

    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public List<Locale> getLanguages() {
        return new ArrayList<Locale>();
    }

    public List<String> getEncodings() {
        return new ArrayList<String>();
    }

    public Request getRequest() {
        return this.request;
    }

    public Providers getProviders() {
        return this.providers;
    }
}

