/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.model.impl;

import com.atomgraph.client.MediaTypes;
import com.atomgraph.client.vocabulary.AC;
import com.atomgraph.core.exception.BadGatewayException;
import com.atomgraph.core.io.ResultSetProvider;
import com.atomgraph.core.model.Resource;
import com.atomgraph.core.util.ModelUtils;
import com.atomgraph.core.util.ResultSetUtils;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.glassfish.jersey.uri.UriComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class ProxyResourceBase
implements Resource {
    private static final Logger log = LoggerFactory.getLogger(ProxyResourceBase.class);
    private final UriInfo uriInfo;
    private final Request request;
    private final HttpHeaders httpHeaders;
    private final MediaTypes mediaTypes;
    private final MediaType accept;
    private final MediaType[] readableMediaTypes;
    private final Client client;
    private final WebTarget webTarget;
    private final URI endpoint;
    private final String query;
    private final HttpServletRequest httpServletRequest;

    @Inject
    public ProxyResourceBase(@Context UriInfo uriInfo, @Context Request request, @Context HttpHeaders httpHeaders, MediaTypes mediaTypes, @QueryParam(value="uri") URI uri, @QueryParam(value="endpoint") URI endpoint, @QueryParam(value="query") String query, @QueryParam(value="accept") MediaType accept, @QueryParam(value="mode") URI mode, Client client, @Context HttpServletRequest httpServletRequest) {
        this.uriInfo = uriInfo;
        this.request = request;
        this.httpHeaders = httpHeaders;
        this.mediaTypes = mediaTypes;
        this.endpoint = endpoint;
        this.query = query;
        this.accept = accept;
        this.client = client;
        ArrayList readableMediaTypesList = new ArrayList();
        readableMediaTypesList.addAll(mediaTypes.getReadable(Model.class));
        readableMediaTypesList.addAll(mediaTypes.getReadable(ResultSet.class));
        this.readableMediaTypes = (MediaType[])readableMediaTypesList.toArray(MediaType[]::new);
        if (uri != null) {
            if (uri.getFragment() != null) {
                try {
                    uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.webTarget = client.target(uri);
        } else {
            this.webTarget = null;
        }
        this.httpServletRequest = httpServletRequest;
    }

    public URI getURI() {
        return this.getWebTarget().getUri();
    }

    public MediaType[] getReadableMediaTypes() {
        return this.readableMediaTypes;
    }

    public List<MediaType> getWritableMediaTypes(Class clazz) {
        if (this.getAcceptMediaType() != null) {
            return Arrays.asList(this.getAcceptMediaType());
        }
        return this.getMediaTypes().getWritable(clazz);
    }

    @GET
    public Response get() {
        return this.get(this.getWebTarget());
    }

    public Response get(WebTarget target) {
        if (target == null) {
            if (this.getEndpoint() != null && this.getQuery() != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Redirecting from endpoint/query URL to a proxied URL");
                }
                String encodedQuery = UriComponent.encode((String)this.getQuery(), (UriComponent.Type)UriComponent.Type.UNRESERVED);
                URI sparqlUrl = UriBuilder.fromUri((URI)this.getEndpoint()).queryParam(AC.query.getLocalName(), new Object[]{encodedQuery}).build(new Object[0]);
                String encodedSparqlUrl = UriComponent.encode((String)sparqlUrl.toString(), (UriComponent.Type)UriComponent.Type.UNRESERVED);
                URI uri = this.getUriInfo().getBaseUriBuilder().queryParam(AC.uri.getLocalName(), new Object[]{encodedSparqlUrl}).build(new Object[0]);
                return Response.seeOther((URI)uri).build();
            }
            throw new NotFoundException("Resource URI not supplied");
        }
        return this.get(target, this.getBuilder(target));
    }

    public Invocation.Builder getBuilder(WebTarget target) {
        return target.request(this.getReadableMediaTypes());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response get(WebTarget target, Invocation.Builder builder) {
        if (target == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        try (Response cr = builder.get();){
            if ((cr.getStatusInfo().toEnum().equals((Object)Response.Status.SEE_OTHER) || cr.getStatusInfo().toEnum().equals((Object)Response.Status.MOVED_PERMANENTLY)) && (target.getUri().getScheme().equals("http") && cr.getLocation().getScheme().equals("https") || target.getUri().getScheme().equals("https") && cr.getLocation().getScheme().equals("http"))) {
                Response response2 = this.get(this.getClient().target(cr.getLocation()));
                return response2;
            }
            cr.getHeaders().putSingle((Object)"X-Request-URI", (Object)target.getUri().toString());
            if (log.isDebugEnabled()) {
                log.debug("GETing Model from URI: {}", (Object)target.getUri());
            }
            Response response3 = this.getResponse(cr);
            List linkValues = (List)cr.getHeaders().get((Object)"Link");
            if (linkValues != null) {
                this.setLinks(linkValues, response3);
            }
            Response response = response3;
            return response;
        }
        catch (ProcessingException ex) {
            if (!log.isErrorEnabled()) throw new BadGatewayException((Throwable)ex);
            log.debug("Could not dereference URI: {}", (Object)this.webTarget.getUri());
            throw new BadGatewayException((Throwable)ex);
        }
    }

    public Response getResponse(Response clientResponse) {
        if (ResultSetProvider.isResultSetType((MediaType)clientResponse.getMediaType())) {
            ResultSetRewindable results = (ResultSetRewindable)clientResponse.readEntity(ResultSetRewindable.class);
            return this.getResponse(results);
        }
        Model description = (Model)clientResponse.readEntity(Model.class);
        return this.getResponse(description);
    }

    public Response getResponse(Model model) {
        List variants = com.atomgraph.core.model.impl.Response.getVariantListBuilder(this.getWritableMediaTypes(Model.class), this.getLanguages(), this.getEncodings()).add().build();
        return new com.atomgraph.core.model.impl.Response(this.getRequest(), (Object)model, null, new EntityTag(Long.toHexString(ModelUtils.hashModel((Model)model))), variants).getResponseBuilder().build();
    }

    public Response getResponse(ResultSetRewindable resultSet) {
        long hash = ResultSetUtils.hashResultSet((ResultSet)resultSet);
        resultSet.reset();
        List variants = com.atomgraph.core.model.impl.Response.getVariantListBuilder(this.getWritableMediaTypes(ResultSet.class), this.getLanguages(), this.getEncodings()).add().build();
        return new com.atomgraph.core.model.impl.Response(this.getRequest(), (Object)resultSet, null, new EntityTag(Long.toHexString(hash)), variants).getResponseBuilder().build();
    }

    protected Response setLinks(List<Object> linkValues, Response response) {
        linkValues.forEach(linkValue -> response.getHeaders().add((Object)"Link", linkValue));
        return response;
    }

    @POST
    public Response post(Model model) {
        if (this.getWebTarget() == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        if (log.isDebugEnabled()) {
            log.debug("POSTing Dataset to URI: {}", (Object)this.getWebTarget().getUri());
        }
        return this.getWebTarget().request().accept((MediaType[])this.getMediaTypes().getReadable(Model.class).toArray(MediaType[]::new)).post(Entity.entity((Object)model, (MediaType)com.atomgraph.core.MediaType.APPLICATION_NTRIPLES_TYPE));
    }

    @PUT
    public Response put(Model model) {
        if (this.getWebTarget() == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        if (log.isDebugEnabled()) {
            log.debug("PUTting Dataset to URI: {}", (Object)this.getWebTarget().getUri());
        }
        return this.getWebTarget().request().accept((MediaType[])this.getMediaTypes().getReadable(Model.class).toArray(MediaType[]::new)).put(Entity.entity((Object)model, (MediaType)com.atomgraph.core.MediaType.APPLICATION_NTRIPLES_TYPE));
    }

    @DELETE
    public Response delete() {
        if (this.getWebTarget() == null) {
            throw new NotFoundException("Resource URI not supplied");
        }
        if (log.isDebugEnabled()) {
            log.debug("DELETEing Dataset from URI: {}", (Object)this.getWebTarget().getUri());
        }
        return (Response)this.getWebTarget().request().accept((MediaType[])this.getMediaTypes().getReadable(Model.class).toArray(MediaType[]::new)).delete(Response.class);
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public MediaType getAcceptMediaType() {
        return this.accept;
    }

    public Client getClient() {
        return this.client;
    }

    public final WebTarget getWebTarget() {
        return this.webTarget;
    }

    public final URI getEndpoint() {
        return this.endpoint;
    }

    public final String getQuery() {
        return this.query;
    }

    public Request getRequest() {
        return this.request;
    }

    public MediaTypes getMediaTypes() {
        return this.mediaTypes;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public List<Locale> getLanguages() {
        return new ArrayList<Locale>();
    }

    public List<String> getEncodings() {
        return new ArrayList<String>();
    }
}

