/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.util;

import com.atomgraph.client.exception.OntologyException;
import com.atomgraph.client.vocabulary.SP;
import com.atomgraph.client.vocabulary.SPIN;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constructor {
    private static final Logger log = LoggerFactory.getLogger(Constructor.class);

    public Resource construct(OntClass forClass, Model targetModel, String baseURI) {
        if (targetModel == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        return this.addInstance(forClass, SPIN.constructor, targetModel.createResource(), baseURI, new HashSet<OntClass>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource constructInstance(OntClass forClass, Property property, Resource instance, String baseURI, Set<OntClass> reachedClasses) {
        block26: {
            if (forClass == null) {
                throw new IllegalArgumentException("OntClass cannot be null");
            }
            if (instance == null) {
                throw new IllegalArgumentException("Instance Resource cannot be null");
            }
            if (baseURI == null) {
                throw new IllegalArgumentException("Base URI cannot be null");
            }
            if (reachedClasses == null) {
                throw new IllegalArgumentException("Set<OntClass> cannot be null");
            }
            if (reachedClasses.contains(forClass)) {
                return instance;
            }
            NodeIterator constructorIt = forClass.listPropertyValues(property);
            while (true) {
                if (!constructorIt.hasNext()) break block26;
                RDFNode constructor = constructorIt.next();
                if (!constructor.isResource()) {
                    if (log.isErrorEnabled()) {
                        log.error("Constructor is invoked but {} is not defined for class '{}'", (Object)property, (Object)forClass.getURI());
                    }
                    throw new OntologyException("Constructor property not defined", (Resource)forClass, property);
                }
                Statement queryText = constructor.asResource().getProperty(SP.text);
                if (queryText == null || !queryText.getObject().isLiteral()) {
                    if (log.isErrorEnabled()) {
                        log.error("Constructor resource '{}' does not have sp:text property", (Object)constructor);
                    }
                    throw new OntologyException("Query property not defined", constructor.asResource(), SP.text);
                }
                try {
                    Query basedQuery = new ParameterizedSparqlString(queryText.getString(), baseURI).asQuery();
                    QuerySolutionMap bindings = new QuerySolutionMap();
                    bindings.add("this", (RDFNode)instance);
                    try (QueryExecution qex = QueryExecution.create().query(basedQuery).model(instance.getModel()).initialBinding((QuerySolution)bindings).build();){
                        instance.getModel().add(qex.execConstruct());
                        reachedClasses.add(forClass);
                    }
                }
                catch (QueryParseException ex) {
                    if (log.isErrorEnabled()) {
                        log.error("Constructor resource '{}' sp:text property contains an invalid SPARQL CONSTRUCT", (Object)constructor);
                    }
                    throw new OntologyException("Invalid SPARQL CONSTRUCT", (Throwable)ex, constructor.asResource(), SP.text);
                }
            }
            finally {
                constructorIt.close();
            }
        }
        try (ExtendedIterator superClassIt = forClass.listSuperClasses();){
            while (superClassIt.hasNext()) {
                OntClass superClass = (OntClass)superClassIt.next();
                this.constructInstance(superClass, property, instance, baseURI, reachedClasses);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource addInstance(OntClass forClass, Property property, Resource instance, String baseURI, Set<OntClass> reachedClasses) {
        if (forClass == null) {
            throw new IllegalArgumentException("OntClass cannot be null");
        }
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        if (instance == null) {
            throw new IllegalArgumentException("Resource cannot be null");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("Base URI string cannot be null");
        }
        if (reachedClasses == null) {
            throw new IllegalArgumentException("Set<OntClass> cannot be null");
        }
        this.constructInstance(forClass, property, instance, baseURI, new HashSet<OntClass>()).addProperty(RDF.type, (RDFNode)forClass);
        reachedClasses.add(forClass);
        try (ExtendedIterator superClassIt = forClass.listSuperClasses();){
            while (superClassIt.hasNext()) {
                AllValuesFromRestriction avfr;
                OntClass superClass = (OntClass)superClassIt.next();
                if (!superClass.canAs(AllValuesFromRestriction.class) || !(avfr = (AllValuesFromRestriction)superClass.as(AllValuesFromRestriction.class)).getAllValuesFrom().canAs(OntClass.class)) continue;
                OntClass valueClass = (OntClass)avfr.getAllValuesFrom().as(OntClass.class);
                if (reachedClasses.contains(valueClass)) {
                    if (log.isErrorEnabled()) {
                        log.error("Circular template restriction between '{}' and '{}' is not allowed", (Object)forClass.getURI(), (Object)valueClass.getURI());
                    }
                    throw new OntologyException("Circular template restriction between '" + forClass.getURI() + "' and '" + valueClass.getURI() + "' is not allowed", (Resource)valueClass, property);
                }
                Resource value = instance.getModel().createResource().addProperty(RDF.type, (RDFNode)valueClass);
                instance.addProperty((Property)avfr.getOnProperty(), (RDFNode)value);
                try (ExtendedIterator it = avfr.getOnProperty().listInverseOf();){
                    while (it.hasNext()) {
                        value.addProperty((Property)it.next(), (RDFNode)instance);
                    }
                }
                this.addInstance(valueClass, property, value, baseURI, reachedClasses);
            }
        }
        return instance;
    }
}

