/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.util;

import java.io.IOException;
import java.util.zip.ZipFile;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipURIResolver
implements URIResolver {
    private static final Logger log = LoggerFactory.getLogger(ZipURIResolver.class);
    private ZipFile zipFile = null;

    public ZipURIResolver(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        if (log.isDebugEnabled()) {
            log.debug("Resolving href: {} base: {}", (Object)href, (Object)base);
        }
        try {
            return new StreamSource(this.getZipFile().getInputStream(this.getZipFile().getEntry(href)));
        }
        catch (IOException ex) {
            if (log.isDebugEnabled()) {
                log.debug("Error resolving from ZipFile", (Throwable)ex);
            }
            return null;
        }
    }
}

