/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.client.writer;

import com.atomgraph.client.util.DataManager;
import com.atomgraph.client.writer.XSLTWriterBase;
import jakarta.inject.Singleton;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XsltExecutable;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Singleton
@Produces(value={"text/html;charset=UTF-8", "application/xhtml+xml;charset=UTF-8"})
public class ModelXSLTWriter
extends XSLTWriterBase
implements MessageBodyWriter<Model> {
    private static final Logger log = LoggerFactory.getLogger(ModelXSLTWriter.class);

    public ModelXSLTWriter(XsltExecutable xsltExec, OntModelSpec ontModelSpec, DataManager dataManager) {
        super(xsltExec, ontModelSpec, dataManager);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Model.class.isAssignableFrom(type);
    }

    public long getSize(Model model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Model model, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headerMap, OutputStream entityStream) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Writing Model with HTTP headers: {} MediaType: {}", headerMap, (Object)mediaType);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("allowBadURIs", "true");
            Context cxt = new Context();
            cxt.set(SysRIOT.sysRdfWriterProperties, properties);
            RDFWriter.create().format(RDFFormat.RDFXML_PLAIN).context(cxt).source(model).output((OutputStream)baos);
            this.transform(baos, mediaType, headerMap, entityStream);
        }
        catch (TransformerException | SaxonApiException ex) {
            if (log.isErrorEnabled()) {
                log.error("XSLT transformation failed", ex);
            }
            throw new InternalServerErrorException(ex);
        }
    }

    public StreamSource getSource(Model model) throws IOException {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Number of Model stmts read: {}", (Object)model.size());
        }
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            model.write((OutputStream)stream, RDFLanguages.RDFXML.getName(), null);
            if (log.isDebugEnabled()) {
                log.debug("RDF/XML bytes written: {}", (Object)stream.toByteArray().length);
            }
            StreamSource streamSource = new StreamSource(new ByteArrayInputStream(stream.toByteArray()));
            return streamSource;
        }
    }
}

